package com.pcloud.book.book.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/12/27 17:20
 **/
@Data
@ApiModel("书籍标签")
public class BookLabel extends BaseEntity {

    @ApiModelProperty("标签名称")
    private String name;

    @ApiModelProperty("标签类型")
    private Integer type;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("审核状态（0待审核1通过2修改入库3未通过）")
    private Integer auditState;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改入库的标签id")
    private Long updateLabelId;

    @ApiModelProperty("申请说明")
    private String remark;

    @ApiModelProperty("排序值")
    private Integer seq;
}
