package com.pcloud.book.cultivate.facade;

import com.pcloud.book.cultivate.biz.CultivateNotifyBiz;
import com.pcloud.book.cultivate.dto.CultivateNotifyDTO;
import com.pcloud.book.cultivate.dto.SearchNotifyDTO;
import com.pcloud.book.cultivate.dto.SearchSendUserDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@Api("站内信")
@RestController("cultivateNotifyFacade")
@RequestMapping("cultivateNotify")
public class CultivateNotifyFacade {

    @Autowired
    private CultivateNotifyBiz cultivateNotifyBiz;



    @ApiOperation("新增站内信")
    @PostMapping("/createCultivateNotify")
    public ResponseDto<?> createCultivate(
            @RequestBody CultivateNotifyDTO cultivateNotifyDTO
    ) throws BizException, PermissionException {
        cultivateNotifyBiz.createNotify(cultivateNotifyDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("站内信列表")
    @PostMapping("/listPage4CultivateNotify")
    public ResponseDto<?> listPage4CultivateNotify(
            @RequestBody SearchNotifyDTO searchNotifyDTO
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateNotifyBiz.listPage4CultivateNotify(searchNotifyDTO));
    }

    @ApiOperation("站内信发送用户列表")
    @PostMapping("/listPage4SendUser")
    public ResponseDto<?> listPage4SendUser(
            @RequestBody SearchSendUserDTO searchSendUserDTO
            ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateNotifyBiz.listPage4SendUser(searchSendUserDTO));
    }

    @ApiOperation("站内信发送书刊列表")
    @PostMapping("/listPage4SearchBook")
    public ResponseDto<?> listPage4SearchBook(
            @RequestBody SearchSendUserDTO searchSendUserDTO
    ) throws BizException, PermissionException {
        return new ResponseDto<>(cultivateNotifyBiz.listPage4SearchBook(searchSendUserDTO));
    }

    @ApiOperation("首条未读消息详情")
    @GetMapping("/getFirstNoReadNotify")
    public  ResponseDto<?> getFirstNoReadNotify(@CookieValue(value = "userInfo" ,required = false) String  userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(cultivateNotifyBiz.getFirstNoReadNotify(wechatUserId));
    }

    @ApiOperation("4种不同类型消息的的列表")
    @GetMapping("/getNotify4Type")
    public  ResponseDto<?> getNotify4Type(@CookieValue(value = "userInfo" ,required = false) String  userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(cultivateNotifyBiz.getNotify4Type(wechatUserId));
    }


    @ApiOperation("单个分类消息列表")
    @GetMapping("/getNotifyListByType")
    public  ResponseDto<?> getNotifyListByType(@CookieValue(value = "userInfo" ,required = false) String  userInfo,@RequestParam Integer messageType,
    @RequestParam(value = "currentPage", required = false) Integer currentPage, @RequestParam(value = "numPerPage", required = false) Integer numPerPage){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw new BizException(BizException.PARAM_IS_NULL.getCode(), "wechatUserId 不能为空");
        }
        return new ResponseDto<>(cultivateNotifyBiz.getNotifyListByType(wechatUserId,messageType,currentPage,numPerPage));
    }





}
