package com.pcloud.book.giftcoupon.dao;

import com.pcloud.book.giftcoupon.dto.GiftReceiveDTO;
import com.pcloud.book.giftcoupon.entity.GiftCouponPackage;
import com.pcloud.book.giftcoupon.entity.GiftReceive;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * 专享礼券包领取表(GiftReceive)表数据库访问层
 *
 * @author makejava
 * @since 2020-04-19 14:59:34
 */
public interface GiftReceiveDao extends BaseDao<GiftReceive> {

    /**
     * 通过ID查询单条数据
     *
     * @return 实例对象
     */
    GiftReceive getGiftReceive(Long wechatUserId,Long giftPackageId);

    Integer getGiftReceiveCount(Long wechatUserId,Long giftPackageId);


    void useGiftCoupon(Long receiveId);

    List<GiftReceiveDTO> getGiftReceiveNumList(List<Long> giftPackageIds);

    List<Long> getUserReceiveGiftId(Long wechatUserId,Long rightsSettingId);

    Map<Long,GiftReceive> getMapByIds(List<Long> giftPackageIds,Long wechatUserId);

    List<GiftCouponPackage> getOverLimitCoupon(List<Long> giftPackageIds,Long wechatUserId);

}