package com.pcloud.book.giftcoupon.dao.impl;

import com.pcloud.book.giftcoupon.dao.GiftReceiveDao;
import com.pcloud.book.giftcoupon.dto.GiftReceiveDTO;
import com.pcloud.book.giftcoupon.entity.GiftCouponPackage;
import com.pcloud.book.giftcoupon.entity.GiftReceive;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("giftReceiveDao")
public class GiftReceiveDaoImpl extends BaseDaoImpl<GiftReceive> implements GiftReceiveDao {

    @Override
    public GiftReceive getGiftReceive(Long wechatUserId, Long giftPackageId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("giftPackageId",giftPackageId);
        return super.getSessionTemplate().selectOne(getStatement("getGiftReceive"),map);
    }

    @Override
    public Integer getGiftReceiveCount(Long wechatUserId, Long giftPackageId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("giftPackageId",giftPackageId);
        return super.getSessionTemplate().selectOne(getStatement("getGiftReceiveCount"),map);
    }

    @Override
    public void useGiftCoupon(Long receiveId) {
        Map<String,Object> map=new HashMap<>();
        map.put("receiveId",receiveId);
        super.getSessionTemplate().update(getStatement("useGiftCoupon"),map);
    }

    @Override
    public List<GiftReceiveDTO> getGiftReceiveNumList(List<Long> giftPackageIds) {
        Map<String,Object> map=new HashMap<>();
        map.put("giftPackageIds",giftPackageIds);
        return super.getSessionTemplate().selectList(getStatement("getGiftReceiveNumList"),map);
    }

    @Override
    public List<Long> getUserReceiveGiftId(Long wechatUserId,Long rightsSettingId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("rightsSettingId",rightsSettingId);
        return super.getSessionTemplate().selectList(getStatement("getUserReceiveGiftId"),map);
    }

    @Override
    public Map<Long, GiftReceive> getMapByIds(List<Long> giftPackageIds,Long wechatUserId) {
        Map<String,Object> map=new HashMap<>();
        map.put("giftPackageIds",giftPackageIds);
        map.put("wechatUserId",wechatUserId);
        return super.getSqlSession().selectMap(super.getStatement("getMapByIds"), map, "gift_package_id");
    }

    @Override
    public List<GiftCouponPackage> getOverLimitCoupon(List<Long> giftPackageIds, Long wechatUserId) {
        Map<String,Object> map=new HashMap<>();
        map.put("giftPackageIds",giftPackageIds);
        map.put("wechatUserId",wechatUserId);
        return super.getSqlSession().selectList(super.getStatement("getOverLimitCoupon"), map);
    }

}
