package com.pcloud.book.group.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import lombok.Data;

import java.util.Date;

/**
 * 社群书小程序码
 */
@Data
public class BookAppletScene extends BaseEntity {

    /**
     * 社群书id
     */
    private Long bookGroupId;

    /**
     * 小睿分类
     */
    private Long raysClassifyId;

    /**
     * 小程序id
     */
    private String appletId;

    /**
     * 小程序url
     */
    private String appletUrl;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date updateTime;

    private Boolean isDelete;

    /**
     * 现代纸书自建码的id
     */
    private Long sceneId;
}
