package com.pcloud.book.pcloudkeyword.biz;

import com.pcloud.book.pcloudkeyword.dto.PcloudKeywordClassifyDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudKeywordClassify;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

public interface PcloudKeywordClassifyBiz {

    /**
     * 新增
     * @param pcloudKeywordClassify
     */
    public Long insert(PcloudKeywordClassify pcloudKeywordClassify);

    /**
     * 修改
     * @param pcloudKeywordClassify
     */
    public void update(PcloudKeywordClassify pcloudKeywordClassify);

    /**
     * 删除
     * @param id
     */
    public void deleteById(Long id);

    /**
     * 更新启用状态
     * @param id
     * @param open
     */
    public void updateOpenStateById(Long id, Boolean open);

    /**
     * 查询
     * @param classify
     * @return
     */
    List<PcloudKeywordClassifyDTO> list(String classify);

    /**
     * 根据小号分类获取平台端关键词分类
     * @param robotClassifyId
     * @return
     */
    PcloudKeywordClassify getKeywordClassifyByRobotClassifyId(Long robotClassifyId);
}
