package com.pcloud.book.riddle.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 点击记录
 */
@ApiModel("猜谜语-埋点")
public class RiddleClickRecord extends BaseEntity{

    @ApiModelProperty("微信群id")
    private String wxGroupId;

    @ApiModelProperty("微信用户id")
    private Long wechatUserId;

    @ApiModelProperty("点击类型（1点击链接2许愿3奖品立即使用4优惠券立即领取）")
    private Integer clickType;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("创建时间")
    private Date createTime;

    public String getWxGroupId() {
        return wxGroupId;
    }

    public void setWxGroupId(String wxGroupId) {
        this.wxGroupId = wxGroupId == null ? null : wxGroupId.trim();
    }

    public Long getWechatUserId() {
        return wechatUserId;
    }

    public void setWechatUserId(Long wechatUserId) {
        this.wechatUserId = wechatUserId;
    }

    public Integer getClickType() {
        return clickType;
    }

    public void setClickType(Integer clickType) {
        this.clickType = clickType;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String toString() {
        return "RiddleClickRecord{" +
                "wxGroupId='" + wxGroupId + '\'' +
                ", wechatUserId=" + wechatUserId +
                ", clickType=" + clickType +
                ", createTime=" + createTime +
                '}';
    }
}