package com.pcloud.book.rightsSetting.dao;

import com.pcloud.book.rightsSetting.dto.RightsSettingDto;
import com.pcloud.book.rightsSetting.dto.RightsSettingShowStateDTO;
import com.pcloud.book.rightsSetting.entity.RightsSetting;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

public interface RightsSettingDAO  extends BaseDao<RightsSetting> {
    int deleteByPrimaryKey(Long id);

    RightsSetting selectByPrimaryKey(Long id);

    int updateByPrimaryKeySelective(RightsSetting record);

    int updateByPrimaryKey(RightsSetting record);

    RightsSettingDto getByLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long volLabelId, Long verLabelId);

    RightsSettingDto getByBookId(Long bookId);

    List<RightsSettingDto> listRightsSettingPage(Map<String,Object> map);

    List<RightsSettingDto> listByBookId(Long bookId);

    void batchUpdateShowState(RightsSettingShowStateDTO rightsSettingShowStateDTO);

    Map<Long, RightsSettingDto> listByBookIds(List<Long> bookIds);
}
