package com.pcloud.book.applet.biz.impl;

import com.alibaba.fastjson.JSONObject;
import com.pcloud.book.applet.biz.AppletThirdResourcesChooseBiz;
import com.pcloud.book.applet.dao.AppletThirdResourcesChooseDao;
import com.pcloud.book.applet.dto.AppletThirdResourcesStaticDTO;
import com.pcloud.book.applet.entity.AppletThirdResourcesChoose;
import com.pcloud.book.applet.enums.AppletThirdResourceTypeEnum;
import com.pcloud.book.consumer.common.ExportConsr;
import com.pcloud.book.consumer.message.MessageConsr;
import com.pcloud.book.util.common.ThreadPoolUtils;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.DateUtils;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.string.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * (AppletThirdResourcesChoose)表服务实现类
 *
 * @author makejava
 * @since 2020-10-14 16:22:28
 */
@Service("appletThirdResourcesChooseBiz")
public class AppletThirdResourcesChooseBizImpl implements AppletThirdResourcesChooseBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletThirdResourcesChooseBizImpl.class);

    @Autowired
    private AppletThirdResourcesChooseDao appletThirdResourcesChooseDao;
    @Autowired
    private ExportConsr exportConsr;
    @Autowired
    private MessageConsr messageConsr;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletThirdResourcesChoose getById(Long id) {
        return appletThirdResourcesChooseDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletThirdResourcesChooseDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletThirdResourcesChoose appletThirdResourcesChoose) {
        appletThirdResourcesChooseDao.insert(appletThirdResourcesChoose);
        return appletThirdResourcesChoose.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletThirdResourcesChoose appletThirdResourcesChoose) {
        if (appletThirdResourcesChoose == null || !NumberUtil.isNumber(appletThirdResourcesChoose.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        appletThirdResourcesChooseDao.update(appletThirdResourcesChoose);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletThirdResourcesChooseDao.deleteById(id);
    }

    @Override
    @ParamLog(value = "查询跟谁学统计数据", isAfterReturn = false)
    public PageBeanNew<AppletThirdResourcesStaticDTO> getListThirdResourcesStatic(Integer currentPage, Integer numPerPage, String source, String keyValue, String queryDate) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("source", source);
        paramMap.put("keyValue", keyValue);
        paramMap.put("queryDate", queryDate);
        PageBeanNew<AppletThirdResourcesStaticDTO> pageBeanNew = appletThirdResourcesChooseDao.listPageNew(new PageParam(currentPage, numPerPage), paramMap, "getListThirdResourcesStatic");
        return pageBeanNew;
    }

    @Override
    public void exportListThirdResourcesStatic(Integer currentPage, Integer numPerPage, String source, String keyValue, String queryDate, Long partyId) {
        ThreadPoolUtils.EXPORT_THREAD_POOL.execute(() -> {
            PageBeanNew<AppletThirdResourcesStaticDTO> resourcesStatic = this.getListThirdResourcesStatic(currentPage, numPerPage, source, keyValue, queryDate);
            List<AppletThirdResourcesStaticDTO> recordList = resourcesStatic.getRecordList();
            if (ListUtils.isEmpty(recordList)) {
                return;
            }
            // 字段名
            String[] rowsName = {"资源编号", "资源名称", "资源链接", "来源", "渠道名称", "类别", "获取二维码人数", "长按扫码人数", "进群次数", "留存数"};
            List<Object[]> dataList = new ArrayList<>();
            Object[] objs;
            for (int i = 0; i < recordList.size(); i++) {
                AppletThirdResourcesStaticDTO resourcesStaticDTO = recordList.get(i);
                objs = new Object[rowsName.length];
                objs[0] = resourcesStaticDTO.getResourceNumber();
                objs[1] = resourcesStaticDTO.getResourceName();
                objs[2] = resourcesStaticDTO.getResourceUrl();
                objs[3] = resourcesStaticDTO.getResourceSource();
                objs[4] = resourcesStaticDTO.getChannelName();
                objs[5] = AppletThirdResourceTypeEnum.FISSIONCHATROOM.code.equals(resourcesStaticDTO.getResourceType()) ?
                        AppletThirdResourceTypeEnum.FISSIONCHATROOM.tyepName : AppletThirdResourceTypeEnum.CHATROOM.tyepName;
                objs[6] = null == resourcesStaticDTO.getGetQrCodeUv() ? 0 : resourcesStaticDTO.getGetQrCodeUv();
                objs[7] = null == resourcesStaticDTO.getPressQrCodeUv() ? 0 : resourcesStaticDTO.getPressQrCodeUv();
                objs[8] = null == resourcesStaticDTO.getJoinChatroomCount() ? 0 : resourcesStaticDTO.getJoinChatroomCount();
                objs[9] = null == resourcesStaticDTO.getStayUserCount() ? 0 : resourcesStaticDTO.getStayUserCount();
                dataList.add(objs);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String fileName ="研发-跟谁学第三方接口数据获取-" + simpleDateFormat.format(new Date());
            String fileUrl = exportConsr.exportExcel(fileName, rowsName, dataList);
            if (!StringUtil.isEmpty(fileUrl)) {
                JSONObject content = new JSONObject();
                content.put("commitTime", DateUtils.formatDate(new Date()));
                content.put("type", "跟谁学第三方接口数据获取导出");
                messageConsr.sendLetter(partyId, partyId, content.toJSONString(), SystemCode.pcloud.code, "book_download", fileUrl, fileName);
            }
        });


    }
}