package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletGroupSearchRecordDao;
import com.pcloud.book.applet.entity.AppletGroupSearchRecord;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * (AppletGroupSearchRecord)表数据库访问层
 *
 * @author zyq
 * @since 2020-04-01 17:34:47
 */
@Repository("appletGroupSearchRecordDaoImpl")
public class AppletGroupSearchRecordDaoImpl extends BaseDaoImpl<AppletGroupSearchRecord> implements AppletGroupSearchRecordDao {

    @Override
    public void deleteByIds(List<Long> list) {
        super.sqlSessionTemplate.delete(getStatement("deleteByIds"), list);
    }

    @Override
    public List<Long> getRecordIdListByUser(Long wechatUserId) {
        return getSessionTemplate().selectList(getStatement("getRecordIdListByUser"), wechatUserId);
    }
}