package com.pcloud.book.advertising.enums;

/**
 * Description 广告形式枚举类
 * Created by PENG on 2019/4/24.
 */
public enum AdPositionModeEnum {

    INFORMATION(AdPositionEnum.BOOK_GROUP_PAGE.positionCode, AdPositionDetailEnum.JOIN_PAGE.detailCode, "INFORMATION", "信息流"),
    BANNER_MIDDLE(AdPositionEnum.BOOK_GROUP_PAGE.positionCode, AdPositionDetailEnum.JOIN_PAGE.detailCode, "BANNER_MIDDLE", "中部通栏"),
    BANNER_BOTTOM(AdPositionEnum.BOOK_GROUP_PAGE.positionCode, AdPositionDetailEnum.GROUP_QRCODE_PAGE.detailCode, "BANNER_BOTTOM", "底部通栏"),
    BANNER_BOTTOM_TRACK(AdPositionEnum.BOOK_GROUP_PAGE.positionCode, AdPositionDetailEnum.FAIL_JOIN_PAGE.detailCode, "BANNER_BOTTOM_TRACK", "底部通栏（跑道式）"),
    DESC_PAGE_HEAD(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "DESC_PAGE_HEAD", "应用说明页头部通栏"),
    DESC_PAGE_MIDDLE(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "DESC_PAGE_MIDDLE", "应用说明页中部通栏"),
    DESC_PAGE_BOTTOM(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "DESC_PAGE_BOTTOM", "应用说明页底部通栏"),
    TOP_FOCUS_PIC_1(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "TOP_FOCUS_PIC_1", "顶部焦点图第1帧"),
    TOP_FOCUS_PIC_2(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "TOP_FOCUS_PIC_2", "顶部焦点图第2帧"),
    UNDER_TITLE_BANNER(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "UNDER_TITLE_BANNER", "标题下通栏"),
    RIGHT_FLOAT_ICON(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "RIGHT_FLOAT_ICON", "右侧浮标"),
    PAY_POP_UP(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "PAY_POP_UP", "付费后弹窗"),
    MINE_TOP_BANNER(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "MINE_TOP_BANNER", "“我的”顶部通栏（大）"),
    TOP_BANNER_SMALL(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "TOP_BANNER_SMALL", "顶部通栏（小）"),
    BOTTOM_FLOAT_ICON(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "BOTTOM_FLOAT_ICON", "底部浮标"),
    BOTTOM_BANNER_LARGE(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "BOTTOM_BANNER_LARGE", "底部通栏（大）"),
    PAY_BOTTOM_BANNER(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "PAY_BOTTOM_BANNER", "应用支付页底部通栏"),
    PIC_IN_PIC_MIDDLE(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "PIC_IN_PIC_MIDDLE", "画中画（中）"),
    PIC_IN_PIC_BOTTOM(AdPositionEnum.APP_OR_PRODUCT.positionCode, null, "PIC_IN_PIC_BOTTOM", "画中画（底）"),
    TEXT_AND_LINK(AdPositionEnum.WECHAT_GROUP_MSG.positionCode, null, "TEXT_AND_LINK", "文字+链接"),
    NEWS_SHARE(AdPositionEnum.WECHAT_GROUP_MSG.positionCode, null, "NEWS_SHARE", "图文分享"),
    JUST_PIC(AdPositionEnum.WECHAT_GROUP_MSG.positionCode, null, "JUST_PIC", "纯图片");

    public final String positionCode;

    public final String detailCode;

    public final String modeCode;

    public final String modeName;

    AdPositionModeEnum(String positionCode, String detailCode, String modeCode, String modeName) {
        this.positionCode = positionCode;
        this.detailCode = detailCode;
        this.modeCode = modeCode;
        this.modeName = modeName;
    }

    /**
     * 校验位置是否存在
     */
    public static Boolean checkCodeExist(String positionCode, String modeCode) {
        AdPositionModeEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdPositionModeEnum adPositionModeEnum = var1[var3];
            if (adPositionModeEnum.positionCode.equals(positionCode) && adPositionModeEnum.modeCode.equals(modeCode)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 根据编码拿名称
     */
    public static String getNameByCode(String modeCode) {
        AdPositionModeEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdPositionModeEnum adPositionModeEnum = var1[var3];
            if (adPositionModeEnum.modeCode.equals(modeCode)) {
                return adPositionModeEnum.modeName;
            }
        }
        return "";
    }
}
