package com.pcloud.book.applet.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("小程序资讯")
public class AppletNews extends BaseEntity {

    @ApiModelProperty("资讯")
    private String newsName;
    @ApiModelProperty("来源")
    private String source;
    @ApiModelProperty("栏目id")
    private Long newsClassifyId;
    @ApiModelProperty("专业标签ID")
    private Long proLabelId;
    @ApiModelProperty("深度标签ID")
    private Long depLabelId;
    @ApiModelProperty("目的标签ID")
    private Long purLabelId;
    @ApiModelProperty("文章版式（1多图文2单图文3纯图片4纯文本)")
    private Integer type;
    @ApiModelProperty("内容摘要")
    private String digest;
    @ApiModelProperty("预览图片1")
    private String pic1;
    @ApiModelProperty("预览图片2")
    private String pic2;
    @ApiModelProperty("预览图片3")
    private String pic3;
    @ApiModelProperty("文章内容")
    private String content;
    @ApiModelProperty("是否展示")
    private Boolean showState;
}
