package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.SearchRecordDao;
import com.pcloud.book.book.entity.SearchRecord;
import com.pcloud.book.book.vo.BookSearchTopVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("searchRecordDao")
public class SearchRecordDaoImpl extends BaseDaoImpl<SearchRecord> implements SearchRecordDao {

    @Override
    public void deleteByWxId(String wxId) {
        super.getSqlSession().delete(super.getStatement("deleteByWxId"),wxId);
    }

    @Override
    public List<String> getRecent5WxIds(Long bookId) {
        return super.getSqlSession().selectList(super.getStatement("getRecent5WxIds"),bookId);
    }

    @Override
    public void updateUserDeleteByWxId(String wxId, Boolean userDelete) {
        Map<String,Object> map=new HashMap<>();
        map.put("wxId",wxId);
        map.put("userDelete",userDelete);
        super.getSqlSession().update(super.getStatement("updateUserDeleteByWxId"),map);
    }

    @Override
    public List<BookSearchTopVO> getBookSearchTop(Integer top) {
        Map<String,Object> map=new HashMap<>();
        map.put("top",top);
        return super.getSqlSession().selectList(super.getStatement("getBookSearchTop"),map);
    }

    @Override
    public void updateUserDeleteByWechatUserId(Long wechatUserId, Boolean userDelete) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("userDelete",userDelete);
        super.getSqlSession().update(super.getStatement("updateUserDeleteByWechatUserId"),map);
    }
}
