package com.pcloud.book.custom.mapper;


import com.pcloud.book.custom.dto.PlanReadTypeDto;
import com.pcloud.book.custom.entity.CustomPlan;
import com.pcloud.book.custom.vo.CustomPlanPaperVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("customPlanMapper")
public interface CustomPlanMapper {

    void insert(CustomPlan customPlan);

    void update(CustomPlan customPlan);

    CustomPlan getById(@Param("id") Integer id);

    void deleteById(@Param("id") Integer id);

    int getCustomPlanCount(@Param("content") String content, @Param("useState") Integer useState, @Param("hasPdf") Integer hasPdf,
                           @Param("robotType") Integer robotType, @Param("readType") Integer readType);

    List<CustomPlan> listCustomPlanByPage(@Param("pageNum") Integer pageNum, @Param("numPerPage") Integer numPerPage, @Param("content") String content, @Param("useState") Integer useState,
                                          @Param("hasPdf") Integer hasPdf, @Param("robotType") Integer robotType,
                                          @Param("readType") Integer readType);

    int getPlanPaperCount(Map<String, Object> paramMap);

    List<CustomPlanPaperVO> listPlanPaperByPage(Map<String, Object> paramMap);

    void updatePdfUrl(CustomPlan customPlan);

    List<PlanReadTypeDto> getPlanReadTypesByBookId(@Param("bookId") Long bookId);

    CustomPlan getLastCustomPlan(@Param("bookIds") List<Long> bookIds,@Param("readType") Integer readType);

    CustomPlan getLastCustomPlanByBookIds(@Param("bookIds") List<Long> bookIds);
}