package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookGroupDao;
import com.pcloud.book.group.dto.AgentStatisticsInfoDTO;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.BookGroupStatistic4AgentDTO;
import com.pcloud.book.group.dto.PersonalQrcodeDTO;
import com.pcloud.book.group.dto.QrcodeNameAndProIdDTO;
import com.pcloud.book.group.dto.TopAgentBookGroupDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.book.group.entity.QrChangeRecord;
import com.pcloud.book.group.vo.BookGroupAnalysisVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Description 社群书群二维码数据访问层接口实现类
 * Created by PENG on 2019/4/17.
 */
@Repository("bookGroupDao")
public class BookGroupDaoImpl extends BaseDaoImpl<BookGroup> implements BookGroupDao {

    /**
     * 获取DTO信息
     */
    @Override
    public BookGroupDTO getDTOById(Long bookGroupId) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"), bookGroupId);
    }

    /**
     * 获取书名和封面
     */
    @Override
    public BookGroupDTO getBookInfo(Long bookGroupId) {
        return super.getSqlSession().selectOne(getStatement("getBookInfo"), bookGroupId);
    }


    /**
     * 批量获取DTO信息
     */
    @Override
    public List<BookGroupDTO> getDTOByIds(List<Long> bookGroupIds) {
        return super.getSqlSession().selectList(getStatement("getDTOByIds"), bookGroupIds);
    }

    /**
     * 获取DTO信息
     */
    @Override
    public BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().selectOne(getStatement("getDTOByBookId"), paramMap);
    }

    @Override
    public List<BookGroupDTO> getDTOByBookIdsAnsAdviserIds(List<Long> bookIds, List<Long> adviserIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookIds",bookIds);
        paramMap.put("adviserIds",adviserIds);
        return super.getSqlSession().selectList(getStatement("getDTOByBookIdsAnsAdviserIds"),paramMap);
    }

    /**
     * 根据书刊ID删除
     */
    @Override
    public long deleteByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().update(getStatement("deleteByBookId"), paramMap);
    }

    /**
     * 根据书刊ID恢复
     */
    @Override
    public long recoverByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return super.getSqlSession().update(getStatement("recoverByBookId"), paramMap);
    }

    /**
     * 关联社群码和社群书
     */
    @Override
    public long linkBookGroup(BookGroup bookGroup) {
        return super.getSqlSession().update(getStatement("linkBookGroup"), bookGroup);
    }

    /**
     * 获取编辑社群书数量
     */
    @Override
    public Integer getBookGroupCount(Long adviserId) {
        return super.getSqlSession().selectOne(getStatement("getBookGroupCount"), adviserId);
    }

    @Override
    public QrcodeNameAndProIdDTO getQrcodeNameAndProId(Long bookGroupId) {
        return super.getSqlSession().selectOne(getStatement("getQrcodeNameAndProId"), bookGroupId);
    }

    @Override
    public Integer getRankType(Long bookGroupId) {
        return super.getSqlSession().selectOne(getStatement("getRankType"), bookGroupId);
    }

    @Override
    public void updateRankType(Long bookGroupId, Integer rankType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookGroupId", bookGroupId);
        paramMap.put("rankType", rankType);
        super.getSqlSession().update(getStatement("updateRankType"), paramMap);
    }

    @Override
    public String getSpareQr(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getSpareQr"), bookGroupId);
    }

    @Override
    public List<BookGroupDTO> getBookBaseInfoByIds(List<Long> bookGroupIds) {
        return this.getSqlSession().selectList(this.getStatement("getBookBaseInfoByIds"), bookGroupIds);
    }

    @Override
    public BookGroupDTO getBaseInfoBySceneId(Long sceneId) {
        return this.getSqlSession().selectOne(this.getStatement("getBaseInfoBySceneId"), sceneId);
    }

    @Override
    public Boolean isSpecialAgent(Long agentId) {
        return this.getSqlSession().selectOne(this.getStatement("isSpecialAgent"), agentId);
    }

    @Override
    public void updatePersonQrcode(PersonalQrcodeDTO personalQrcodeDTO) {
        Map<String,Object> map = new HashMap<>();
        map.put("newQrcodeUrl",personalQrcodeDTO.getNewQrcodeUrl());
        map.put("oldQrcodeUrl",personalQrcodeDTO.getOldQrcodeUrl());
        this.getSqlSession().update(this.getStatement("updatePersonQrcode"), map);
    }

    @Override
    public List<BookGroupDTO> getBookInfoByIdsWithBookClockInfoId(Map<String,Object> paramMap) {
        return this.getSqlSession().selectList(this.getStatement("getBookInfoByIdsWithBookClockInfoId"), paramMap);
    }

    @Override
    public void updateIsShowBookName(Boolean isShowBookName, Long partyId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("isShowBookName", isShowBookName);
        paramMap.put("partyId", partyId);
        super.getSqlSession().update(getStatement("updateIsShowBookName"), paramMap);
    }

    @Override
    public Boolean getIsShowBookName(Long partyId) {
        return this.getSqlSession().selectOne(this.getStatement("getIsShowBookName"), partyId);
    }

    @Override
    public void deleteByBookGroupId(Long bookGroupId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookGroupId", bookGroupId);
        super.getSqlSession().update(getStatement("deleteByBookGroupId"), paramMap);
    }

    @Override
    public BookGroupDTO getBookBaseInfoById(Long bookGroupId) {
        return this.getSqlSession().selectOne(this.getStatement("getBookBaseInfoById"), bookGroupId);
    }

    @Override
    public Integer getBookGroupFriendsCountByAdviser(Long adviserId) {
        return this.getSqlSession().selectOne(getStatement("getBookGroupFriendsCountByAdviser"), adviserId);
    }

    @Override
    public BookGroup getByBookGroupCipher(String bookGroupCipher) {
        return this.getSqlSession().selectOne(getStatement("getByBookGroupCipher"), bookGroupCipher);
    }

    @Override
    public List<BookGroup> getBookGroupByJoinGroupType(Integer joinGroupType) {
        return this.getSqlSession().selectList(getStatement("getBookGroupByJoinGroupType"), joinGroupType);
    }

    @Override
    public List<BookGroup> getNoCipherSelfBookGroups() {
        return this.getSqlSession().selectList(getStatement("getNoCipherSelfBookGroups"));
    }

    @Override
    public void updateCipher(Long id, String bookGroupCipher) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("bookGroupCipher", bookGroupCipher);
        super.getSqlSession().update(getStatement("updateCipher"), paramMap);
    }

    @Override
    public void updateJoinGroupType(Long id, Integer joinGroupType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("joinGroupType", joinGroupType);
        super.getSqlSession().update(getStatement("updateJoinGroupType"), paramMap);
    }

    @Override
    public List<BookGroupAnalysisVO> listPageBookGroupAnalysis(Map<String, Object> paramMap) {
        return getSessionTemplate().selectList(getStatement("listPageBookGroupAnalysis"), paramMap);
    }

    @Override
    public void updateIsInviteGroup(Long id, Boolean isInviteGroup) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("isInviteGroup", isInviteGroup);
        super.getSqlSession().update(getStatement("updateIsInviteGroup"), paramMap);
    }

    @Override
    public void updateIsSomeUpdate(Long id, Boolean isSomeUpdate) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("isSomeUpdate", isSomeUpdate);
        super.getSqlSession().update(getStatement("updateIsSomeUpdate"), paramMap);
    }

    @Override
    public void updateLastPushUpdateTime(Long bookGroupId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookGroupId", bookGroupId);
        super.getSqlSession().update(getStatement("updateLastPushUpdateTime"), paramMap);
    }

    @Override
    public Integer getBookGroupCountByJoinGroupType(Integer joinGroupType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("joinGroupType", joinGroupType);
        return this.getSqlSession().selectOne(this.getStatement("getBookGroupCountByJoinGroupType"), paramMap);
    }

    @Override
    public List<Long> getEmptyAgentIdAdviserId() {
        return this.getSqlSession().selectList(this.getStatement("getEmptyAgentIdAdviserId"));
    }

    @Override
    public void updateAgentIdByAdviserId(Long adviserId, Long agentId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("adviserId", adviserId);
        paramMap.put("agentId", agentId);
        super.getSqlSession().update(getStatement("updateAgentIdByAdviserId"), paramMap);
    }

    @Override
    public List<TopAgentBookGroupDTO> getTopAgentCreateBookGroup(Integer joinGroupType, Integer top, List<Long> agentIds) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("joinGroupType", joinGroupType);
        paramMap.put("top", top);
        paramMap.put("agentIds", agentIds);
        return super.getSqlSession().selectList(getStatement("getTopAgentCreateBookGroup"), paramMap);
    }

    @Override
    public List<Long> get1v1HasClassifyBookGroupIds() {
        return super.getSqlSession().selectList(getStatement("get1v1HasClassifyBookGroupIds"));
    }

    @Override
    public List<String> getRobotWxidsByAgent(Long agentId) {
        return super.getSqlSession().selectList(getStatement("getRobotWxidsByAgent"), agentId);
    }

    @Override
    public List<AgentStatisticsInfoDTO> getAgentStatisticsInfo(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("getAgentStatisticsInfo"), paramMap);
    }

    @Override
    public Integer countSelfBookGroupStatistics(Map<String, Object> map) {
        return super.getSqlSession().selectOne(getStatement("countSelfBookGroupStatistics"),map);
    }

    @Override
    public List<Long> getIdsByJoinGroupType(Integer joinGroupType) {
        Map<String, Object> map = new HashMap<>();
        map.put("joinGroupType", joinGroupType);
        return super.getSqlSession().selectList(getStatement("getIdsByJoinGroupType"),map);
    }

    @Override
    public void insertQrChangeRecord(QrChangeRecord qrChangeRecord) {
        getSessionTemplate().insert(getStatement("insertQrChangeRecord"), qrChangeRecord);
    }

    @Override
    public Long getChangeQrChangeTarget(Long originId, String originType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("originId", originId);
        paramMap.put("originType", originType);
        return getSessionTemplate().selectOne(getStatement("getChangeQrChangeTarget"), paramMap);
    }

    @Override
    public List<BookGroupDTO> getAssocBookGroupByAppInfo(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("getAssocBookGroupByAppInfo"), paramMap);
    }

    @Override
    public void updateSpecialState(Long id, Boolean belongSpecialAgent) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("belongSpecialAgent", belongSpecialAgent);
        getSessionTemplate().update(getStatement("updateSpecialState"), paramMap);
    }

    @Override
    public BookGroupStatistic4AgentDTO getBaseInfoByBookId(Long bookId) {
        return getSessionTemplate().selectOne(getStatement("getBaseInfoByBookId"), bookId);
    }

    @Override
    public BookGroup getByShortBookName(String shortBookName) {
        return super.getSqlSession().selectOne(getStatement("getByShortBookName"),shortBookName);
    }

    @Override
    public List<BookGroup> listOldLabel() {
        return getSessionTemplate().selectList(getStatement("listOldLabel"));
    }

    @Override
    public void updateSubjectByProLabel(Long proLebelId, Long subjectId) {
        Map<String,Object> map = new HashMap<>();
        map.put("proLabelId", proLebelId);
        map.put("subLabelId", subjectId);
        getSessionTemplate().update(getStatement("updateSubjectByProLabel"),map);
    }

    @Override
    public void updateGradeByDepLabel(Long depLabelId, Long graLabelId) {
        Map<String,Object> map = new HashMap<>();
        map.put("depLabelId", depLabelId);
        map.put("graLabelId", graLabelId);
        getSessionTemplate().update(getStatement("updateGradeByDepLabel"),map);
    }

    @Override
    public Long getBookGroupId4OldData(Long raysBookId) {
        return getSessionTemplate().selectOne(getStatement("getBookGroupId4OldData"), raysBookId);
    }

    @Override
    public Long getIdByBookNameAndJoinGroupType(String bookName, Integer joinGroupType) {
        Map<String,Object> map = new HashMap<>();
        map.put("bookName", bookName);
        map.put("joinGroupType", joinGroupType);
        return getSessionTemplate().selectOne(getStatement("getIdByBookNameAndJoinGroupType"),map);
    }
}
