package com.pcloud.book.pcloudkeyword.facade;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotClassifyBiz;
import com.pcloud.book.pcloudkeyword.dto.ClassifyWelcomeDTO;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobotClassify;
import com.pcloud.book.pcloudkeyword.facade.response.PcloudRobotClassifyResponseVO;
import com.pcloud.book.pcloudkeyword.vo.ClassifySeqNumUpdateVO;
import com.pcloud.common.dto.ResponseDto;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

import javax.annotation.Resource;

@RestController
@RequestMapping("pcloudRobotClassify")
public class PcloudRobotClassifyFacade {

    @Resource
    private PcloudRobotClassifyBiz pcloudRobotClassifyBiz;

    @GetMapping("listClassify")
    public ResponseDto<List<PcloudRobotClassifyResponseVO>> listClassify() {
        List<PcloudRobotClassifyResponseVO> classify = pcloudRobotClassifyBiz.listAllRobotClassify();
        return new ResponseDto<>(classify);
    }

    @PostMapping("saveRobotClassify")
    public ResponseDto<Void> saveRobotClassify(@RequestParam("classifyName") String classifyName) {
        pcloudRobotClassifyBiz.saveRobotClassify(classifyName);
        return new ResponseDto<>();
    }

    @PostMapping("updateRobotClassify")
    public ResponseDto<Void> updateRobotClassify(@RequestBody PcloudRobotClassify classify) {
        pcloudRobotClassifyBiz.updateRobotClassify(classify);
        return new ResponseDto<>();
    }

    @GetMapping("getClassifyById")
    public ResponseDto<PcloudRobotClassify> getClassifyById(@RequestHeader("token") @ApiParam("token信息") String token,
                                                            @RequestParam("id") Long id) throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotClassifyBiz.getClassifyById(id));
    }

    @GetMapping("listClassifyByPage")
    public ResponseDto<?> listClassifyByPage(
            @RequestParam(value = "testShow", required = false) Boolean testShow,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage)  throws BizException, PermissionException {
        return new ResponseDto<>(pcloudRobotClassifyBiz.listClassifyByPage(currentPage, numPerPage, testShow));
    }

    @GetMapping("listClassifyByPage4Mini")
    public ResponseDto<?> listClassifyByPage4Mini(
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage)  throws BizException, PermissionException {
        return new ResponseDto<>(pcloudRobotClassifyBiz.listClassifyByPage4Mini(currentPage, numPerPage));
    }

    @GetMapping("getClassifyWelcome")
    public ResponseDto<?> getClassifyWelcome(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("classifyId") @ApiParam("分类ID")  Long classifyId,@RequestParam("robotType") @ApiParam("分类ID")  Integer robotType)  throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(pcloudRobotClassifyBiz.getClassifyWelcome(classifyId,robotType));
    }

    @PostMapping("updateClassifyWelcome")
    public ResponseDto<?> updateClassifyWelcome(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody ClassifyWelcomeDTO classifyWelcomeDTO)  throws BizException, PermissionException {
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotClassifyBiz.updateClassifyWelcome(classifyWelcomeDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("更新小号分类关键词分类")
    @PostMapping("updateRobotClassifyKeywordClassify")
    public ResponseDto<?> updateRobotClassifyKeywordClassify(@RequestBody PcloudRobotClassify classify) {
        pcloudRobotClassifyBiz.updateRobotClassifyKeywordClassify(classify);
        return new ResponseDto<>();
    }

    @ApiOperation("更新小号分类排序值")
    @PostMapping("updateSeqNum4RobotClassify")
    public ResponseDto<?>  updateSeqNum4RobotClassify(@RequestHeader("token") String token, @RequestBody ClassifySeqNumUpdateVO vo) throws BizException, PermissionException {
        Optional.ofNullable(vo).orElseThrow(() -> new BookBizException(BookBizException.ERROR, "参数不能为空"));
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        pcloudRobotClassifyBiz.updateSeqNum4RobotClassify(vo);
        return new ResponseDto<>();
    }

    @ApiOperation("测试sentry")
    @GetMapping("testSentry")
    public ResponseDto<?>  testSentry() throws BizException {
        pcloudRobotClassifyBiz.testSentry();
        return new ResponseDto<>();
    }
}
