package com.pcloud.book.pcloudkeyword.service.impl;

import com.pcloud.book.pcloudKeyword.dto.PcloudRobotDTO;
import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.book.pcloudKeyword.service.PcloudRobotService;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotBiz;
import com.pcloud.book.pcloudkeyword.biz.PcloudRobotClassifyBiz;
import com.pcloud.book.pcloudkeyword.entity.PcloudRobot;
import com.pcloud.book.personalstage.biz.PersonalStageJumpBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.BeanUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequestMapping("pcloudRobotService")
@RestController("pcloudRobotService")
public class PcloudRobotServiceImpl implements PcloudRobotService {

    @Autowired
    private PcloudRobotBiz pcloudRobotBiz;

    @Autowired
    private PersonalStageJumpBiz personalStageJumpBiz;
    @Autowired
    private PcloudRobotClassifyBiz pcloudRobotClassifyBiz;

    @Override
    @PostMapping("getRobotClassifyBatch")
    public ResponseEntity<ResponseDto<Map<String, RobotClassifyDTO>>> getRobotClassifyBatch(@RequestBody List<String> robotIds) {
        return ResponseHandleUtil.toResponse(pcloudRobotBiz.mapByIds4Classify(robotIds));
    }

    @Override
    @GetMapping("getAllPcloudRobot")
    public ResponseEntity<ResponseDto<List<RobotClassifyDTO>>> getAllPcloudRobot() {
        return ResponseHandleUtil.toResponse(pcloudRobotBiz.getAllPcloudRobot());
    }

    @Override
    @GetMapping("getAllPcloudRobotByType")
    public ResponseEntity<ResponseDto<List<RobotClassifyDTO>>> getAllPcloudRobotByType(@RequestParam(value = "groupRobotType",required = false)  Integer groupRobotType) {
        return ResponseHandleUtil.toResponse(pcloudRobotBiz.getAllPcloudRobotByType(groupRobotType));
    }

    @Override
    @PostMapping("addPcloudRobot")
    public void addPcloudRobot(@RequestBody PcloudRobotDTO pcloudRobotDTO) {
        PcloudRobot pcloudRobot = new PcloudRobot();
        BeanUtils.copyProperties(pcloudRobotDTO, pcloudRobot);
        pcloudRobotBiz.createPcloudRobot(pcloudRobot);
    }

    @Override
    @PostMapping("modifyPcloudRobot")
    public void modifyPcloudRobot(@RequestBody PcloudRobotDTO pcloudRobotDTO) {
        PcloudRobot pcloudRobot = new PcloudRobot();
        BeanUtils.copyProperties(pcloudRobotDTO, pcloudRobot);
        pcloudRobotBiz.updatePcloudRobotByWxId(pcloudRobot);
    }
    @Override
    @GetMapping("getPcloudRobotByType")
    public ResponseEntity<ResponseDto<List<String>>>getPcloudRobotByType(@RequestParam("robotType") Long robotType){
        Integer type = robotType.intValue();
        List<String> allRobot = pcloudRobotBiz.getPcloudRobotByClassify(type);
        return ResponseHandleUtil.toResponse(allRobot);
    }

    @Override
    @GetMapping("getPcloudRobotByRobotType")
    public ResponseEntity<ResponseDto<List<String>>> getPcloudRobotByRobotType(@RequestParam("robotType")Long robotType,@RequestParam("groupRobotType") Integer groupRobotType) {
        Integer type = robotType.intValue();
        List<String> allRobot = pcloudRobotBiz.getPcloudRobotByRobotType(type,groupRobotType);
        return ResponseHandleUtil.toResponse(allRobot);
    }

    @Override
    @PostMapping("getPcloudRobotByRobotIds")
    public ResponseEntity<ResponseDto<Map<String, PcloudRobotDTO>>> getPcloudRobotByRobotIds(@RequestBody List<String> robotIds) {
        Map<String,PcloudRobotDTO> map=new HashMap<>();
        for (String robotId:robotIds) {
            PcloudRobot pcloudRobot = pcloudRobotBiz.getPcloudRobotByWxId(robotId);
            PcloudRobotDTO pcloudRobotDTO=new PcloudRobotDTO();
            BeanUtils.copyProperties(pcloudRobot,pcloudRobotDTO);
            if(pcloudRobot!=null) {
                map.put(robotId, pcloudRobotDTO);
            }

        }
        return ResponseHandleUtil.toResponse(map);
    }

    @Override
    @GetMapping("changePersonalStage")
    public void changePersonalStage(@RequestParam("robotId") String robotId, @RequestParam("wxUserId") String wxUserId,
                                    @RequestParam("paperId") Long paperId, @RequestParam("emailContent") String emailContent) {
        if (!personalStageJumpBiz.handlePersonalStagePaperJump(wxUserId, robotId, paperId, emailContent)){
            //如果没有进行跳转，则发送需求单反馈邮件
            personalStageJumpBiz.sendPaperEmail(wxUserId, robotId, emailContent);
        }
    }

    @Override
    @GetMapping("handleMiniAppQr")
    public void handleMiniAppQr() {
        pcloudRobotBiz.handleMiniAppQr();
    }

    @Override
    @GetMapping("getValidPcloudRobotByType")
    public ResponseEntity<ResponseDto<PcloudRobotDTO>> getValidPcloudRobotByType(Long robotType) {
        PcloudRobotDTO pcloudRobotDTO = pcloudRobotBiz.getValidPcloudRobotByType(robotType);
        return ResponseHandleUtil.toResponse(pcloudRobotDTO);
    }

    @Override
    @GetMapping("getClassifyInfo")
    public ResponseEntity<ResponseDto<RobotClassifyDTO>> getClassifyInfo(Long robotType) {
        return  ResponseHandleUtil.toResponse(pcloudRobotClassifyBiz.getClassifyInfo(robotType));
    }


}
