package com.pcloud.book.timecontrol.facade.impl;

import com.pcloud.book.timecontrol.biz.TaskBiz;
import com.pcloud.book.timecontrol.biz.TaskSubscribeBiz;
import com.pcloud.book.timecontrol.entity.TimeControlTaskSubscribe;
import com.pcloud.book.timecontrol.vo.KeyWordTaskVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.book.timecontrol.dto.CreateTaskDto;
import com.pcloud.book.timecontrol.dto.CreateTaskItemDto;
import com.pcloud.book.timecontrol.dto.ReplyMessageBaseDto;
import com.pcloud.book.timecontrol.dto.TaskDto;
import com.pcloud.book.timecontrol.dto.UpdateTaskDto;
import com.pcloud.book.timecontrol.dto.UpdateTaskItemDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @date: 2020年01月30日 11:29
 * @Author: Zcy
 * @Descprition
 */
@Api(value = "时间管理任务模板配置")
@RequestMapping(value = "/task")
@RestController("taskFacade")
public class TimeControlTaskFacadeImpl {

    @Autowired
    private TaskBiz taskBiz;
    @Autowired
    private TaskSubscribeBiz taskSubscribeBiz;

    @PostMapping("createTask")
    @ApiOperation(value = "创建任务模板", httpMethod = "POST")
    ResponseDto<Integer> createTask(@RequestHeader("token") String token, @RequestBody CreateTaskDto createTaskDto) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(taskBiz.createTask(createTaskDto));
    }

    @ApiOperation(value = "删除任务模板", httpMethod = "GET")
    @GetMapping("deleteTask")
    ResponseDto<?> deleteTask(@RequestHeader("token") String token, @RequestParam(value = "taskId") Integer taskId) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        taskBiz.deleteTask(taskId);
        return new ResponseDto<>(taskId);
    }

    @PostMapping("updateTask")
    @ApiOperation(value = "修改任务模板", httpMethod = "POST")
    ResponseDto<?> updateTask(@RequestHeader("token") String token, @RequestBody @Validated UpdateTaskDto updateTaskDto) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        taskBiz.updateTask(updateTaskDto);
        return new ResponseDto<>();
    }

    @GetMapping("getTask")
    @ApiOperation(value = "获取任务信息", httpMethod = "GET")
    ResponseDto<TaskDto> getTask(@RequestHeader("token") String token, @RequestParam("taskId") Integer taskId) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(taskBiz.getTaskById(taskId));
    }

    @GetMapping("listTask4Pcloud")
    @ApiOperation(value = "平台端查询任务列表", httpMethod = "GET")
    ResponseDto<PageBeanNew<TaskDto>> listTask4Pcloud(@RequestHeader("token") String token, @RequestParam Integer currentPage, @RequestParam Integer numPerPage,
                                                      @RequestParam(value = "search", required = false) String search) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<TaskDto> pageResult = taskBiz.listTask4Pcloud(currentPage, numPerPage, search);
        return new ResponseDto<>(pageResult);
    }

    @PostMapping("createTaskItem")
    @ApiOperation(value = "创建消息配置", httpMethod = "POST")
    ResponseDto<?> createTaskItem(@RequestHeader("token") String token, @RequestBody @Validated CreateTaskItemDto createTaskItemDto) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(taskBiz.createTaskItem(createTaskItemDto));
    }

    @GetMapping("deleteTaskItem")
    @ApiOperation(value = "删除消息配置", httpMethod = "GET")
    ResponseDto<?> deleteTaskItem(@RequestHeader("token") String token, @RequestParam Integer id) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        taskBiz.deleteTaskItem(id);
        return new ResponseDto<>();
    }

    @PostMapping("updateTaskItem")
    @ApiOperation(value = "修改消息配置", httpMethod = "POST")
    ResponseDto<?> updateTaskItem(@RequestHeader("token") String token, @RequestBody @Validated UpdateTaskItemDto updateTaskItemDto) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        taskBiz.updateTaskItem(updateTaskItemDto);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "获取一条消息配置", httpMethod = "GET")
    @GetMapping("getOneTaskItem")
    ResponseDto<?> getOneTaskItem(@RequestHeader("token") String token, @RequestParam Integer id) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(taskBiz.getTaskItem(id));
    }

    @ApiOperation(value = "获取任务模板下所有消息配置天数", httpMethod = "GET")
    @GetMapping("listTaskItemDay")
    ResponseDto<?> listTaskItemDay(@RequestHeader("token") String token, @RequestParam Integer taskId) throws PermissionException {
        SessionUtil.getToken4Redis(token);
        List<ReplyMessageBaseDto> resultList = taskBiz.listTaskItemDay(taskId);
        return new ResponseDto<>(resultList);
    }

    @ApiOperation(value = "客户端订阅任务", httpMethod = "GET")
    @GetMapping("subscribeTask")
    ResponseDto<?> subscribeTask(@RequestParam String wxUserId, @RequestParam Integer taskId, @RequestParam String robotWxId) {
        taskSubscribeBiz.subscribeTask(wxUserId, null, taskId, robotWxId);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "取消订阅任务", httpMethod = "GET")
    @GetMapping("unsubscribeTask")
    ResponseDto<?> unsubscribeTask(@RequestParam String wxUserId, @RequestParam Integer taskId) {
        taskSubscribeBiz.unSubscribeTask(wxUserId, null, taskId);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "temp-接口H5技能聚合页面获取读书计划", httpMethod = "GET")
    @GetMapping("listKeyWordTask")
    ResponseDto<List<KeyWordTaskVO>> listKeyWordTask(){
        List<KeyWordTaskVO> resultList = taskBiz.listKeyWordTask();
        return new ResponseDto<>(resultList);
    }

    @ApiOperation(value = "H5聚合页通过关键词获取任务", httpMethod = "GET")
    @GetMapping("getTaskByKey")
    ResponseDto<?> getTaskByKey(@RequestParam("search") String search, @RequestParam("wxUserId") String wxUserId){
        TaskDto taskDto = taskBiz.getTaskByKey(search, wxUserId);
        return new ResponseDto<>(taskDto);
    }

    @ApiOperation(value = "查询订阅状态", httpMethod = "GET")
    @GetMapping("getSubscribeState")
    ResponseDto<?> getSubscribeState(@RequestParam String wxUserId, @RequestParam Integer taskId){
        TimeControlTaskSubscribe timeControlTaskSubscribe = taskSubscribeBiz.getSubscribeState(wxUserId, taskId);
        return new ResponseDto<>(timeControlTaskSubscribe);
    }

    @ApiOperation(value = "客户端点击链接完成任务", httpMethod = "GET")
    @GetMapping("finishTaskSend")
    ResponseDto<?> finishTaskSend(@RequestParam("taskSendId") Integer taskSendId){
        taskBiz.finishTaskSend(taskSendId);
        return new ResponseDto<>();
    }

    @ApiOperation(value = "复制消息配置", httpMethod = "GET")
    @GetMapping("copyTaskItem")
    ResponseDto<?> copyTaskItem(@RequestHeader String token, @RequestParam Integer taskItemId){
        Integer id = taskBiz.copyTaskItem(taskItemId);
        return new ResponseDto<>(id);
    }
}