package com.pcloud.book.timecontrol.service.impl;

import com.pcloud.book.timecontrol.biz.TaskBiz;
import com.pcloud.book.timecontrol.biz.TaskSubscribeBiz;
import com.pcloud.book.timecontrol.dto.BookTaskBindingDto;
import com.pcloud.book.timecontrol.dto.LabelDto;
import com.pcloud.book.timecontrol.dto.TaskDto;
import com.pcloud.book.timecontrol.mapper.TimeControlTaskMapper;
import com.pcloud.book.timecontrol.service.TimeControlTaskService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;


@RestController("timeControlTaskService")
@RequestMapping("timeControlTaskService")
public class TimeControlTaskServiceImpl implements TimeControlTaskService {

    @Autowired
    private TaskSubscribeBiz taskSubscribeBiz;
    @Autowired
    private TaskBiz taskBiz;
    @Autowired
    private TimeControlTaskMapper taskMapper;

    @Override
    @GetMapping("sendTimeTaskMessage")
    public void sendTimeTaskMessage() {
        new Thread(() -> {
            taskSubscribeBiz.sendTimeTaskMessage();
        }).start();
    }

    @Override
    @GetMapping("getTaskById")
    public ResponseEntity<ResponseDto<TaskDto>> getTaskById(@RequestParam(value = "taskId") Integer taskId) {
        return ResponseHandleUtil.toResponse(taskBiz.getTaskById(taskId));
    }

    @Override
    @GetMapping("listTask")
    public ResponseEntity<ResponseDto<List<BookTaskBindingDto>>> listTask(@RequestParam(value = "search", required = false) String search) {
        List<BookTaskBindingDto> list = taskBiz.listTask(search);
        return ResponseHandleUtil.toResponse(list);
    }

    @Override
    @PostMapping("getTaskBatch")
    public ResponseEntity<ResponseDto<Map<Integer, TaskDto>>> getTaskBatch(@RequestBody List<Integer> taskIds) {
        return ResponseHandleUtil.toResponse(taskMapper.mapByIds(taskIds));
    }

    @Override
    @GetMapping("listMaxDepLabel")
    public ResponseEntity<ResponseDto<List<LabelDto>>> listMaxDepLabel(@RequestParam(value = "num", required = false) Integer num) {
        List<LabelDto> list = taskBiz.listMaxDepLabel(num);
        return ResponseHandleUtil.toResponse(list);
    }

    @Override
    @GetMapping("listTaskByKey4User")
    public ResponseEntity<ResponseDto<List<TaskDto>>> listTaskByKey4User(@RequestParam("wxUserId") String wxUserId, @RequestParam("search") String search) {
        List<TaskDto> list = taskBiz.listTaskByKey4User(wxUserId, search);
        return ResponseHandleUtil.toResponse(list);
    }

    @Override
    @PostMapping("listTaskByIds4User")
    public ResponseEntity<ResponseDto<List<TaskDto>>> listTaskByIds4User(@RequestParam("wxUserId") String wxUserId, @RequestBody List<Integer> taskIds) {
        List<TaskDto> list = taskBiz.listTaskByIds4User(wxUserId, taskIds);
        return ResponseHandleUtil.toResponse(list);
    }

    @Override
    @GetMapping("listTaskByLabelIds4User")
    public ResponseEntity<ResponseDto<List<TaskDto>>> listTaskByLabelIds4User(@RequestParam("wxUserId") String wxUserId, @RequestParam("labelId") Long labelId) {
        List<TaskDto> list = taskBiz.listTaskByLabelIds4User(wxUserId, labelId);
        return ResponseHandleUtil.toResponse(list);
    }

    @Override
    @GetMapping("unSubscribeTask")
    public void unSubscribeTask(@RequestParam("wxId") String wxId, @RequestParam("taskId") Integer taskId) {
        taskSubscribeBiz.unSubscribeTask(wxId, null, taskId);
    }

}
