/**
 *
 */
package com.pcloud.book.book.service;

import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @描述：编辑推广书籍接口类
 * @作者：songx
 * @创建时间：2017年1月4日,下午7:57:04 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookAdviserServiceCloud", path = "book/v1.0/bookAdviserService")
@Api(description = "编辑推广书籍内部服务")
public interface BookAdviserService {

    /**
     * 获取编辑的推广书籍总数
     *
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "获取编辑的推广书籍总数", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "adviserIds", value = "编辑id集合", dataType = "List<Long>", paramType = "body")})
    @RequestMapping(value = "/getCountByAdvisers", method = RequestMethod.POST)
    ResponseEntity<ResponseDto<Map<Long, BookAdviserDto>>> getCountByAdvisers(@RequestBody(required = false) List<Long> adviserIds)
            throws BizException;

    /**
     * 根据ISBN码获取书籍
     *
     * @param bookId
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "根据ISBN码获取书籍", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getByIsbn", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<BookAdviserDto>> getByIsbn(@RequestParam(value = "isbn", required = false) String isbn,
                                                          @RequestParam(value = "channelId", required = false) Long channelId) throws BizException;

    /**
     * @param bookId
     * @param channelId
     * @return
     * @throws BizException
     * @throws @author:     lihao
     * @Title: getMainAdviserId
     * @Description:根据图书信息获取主编辑ID
     * @return: Long
     * @date: 2017年7月12日 上午10:54:24
     */
    @ApiOperation(value = "根据图书信息获取主编辑ID", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/getMainAdviserId", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<Long>> getMainAdviserId(@RequestParam(value = "bookId", required = false) Long bookId,
                                                       @RequestParam(value = "channelId", required = false) Long channelId) throws BizException;

    /**
     * 创建默认图书与编辑的关系
     *
     * @param agentId 出版标识
     * @param adviserId 编辑标识
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "创建默认图书与编辑的关系", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "/createDefaultBook", method = RequestMethod.GET)
    ResponseEntity<ResponseDto<Long>> createDefaultBook( @RequestParam(value = "adviserId", required = false) Long adviserId) throws BizException;
    
    
    /**
     * 设置编辑图书使用模板
     *
     * @param bookAdviser 编辑图书实体
     * @return
     * @throws BizException
     */
    @ApiOperation(value = "设置编辑图书使用模板", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookAdviser", value = "编辑图书实体", dataType = "BookAdviser", paramType = "body")})
    @RequestMapping(value = "/setBookTemplet", method = RequestMethod.GET)
    void setBookTemplet(@RequestBody BookAdviser bookAdviser) throws BizException;
    
    
    
}
