/**
 *
 */
package com.pcloud.book.book.facade;

import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.dto.BookProductDto;
import com.pcloud.book.book.entity.BookProduct;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.codehaus.jackson.JsonParseException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2016年12月23日,下午4:06:04 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookProductFacadeCloud", path = "book/v1.0/bookProduct")
@Api(description = "书籍作品接口外部服务")
public interface BookProductFacade {

    /**
     * 添加书籍和作品关联关系
     *
     * @param token
     * @param bookApp
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "添加书籍和作品关联关系", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookProduct", value = "书籍作品实体", dataType = "BookProduct", paramType = "body")})
    @RequestMapping(value = "create", method = RequestMethod.POST)
    public ResponseDto<BookProductDto> create(@RequestHeader("token") String token,
                                              @RequestBody BookProduct bookProduct) throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端添加书籍和作品关联关系
     *
     * @param token
     * @param bookApp
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "微信端添加书籍和作品关联关系", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookProduct", value = "书籍作品实体", dataType = "BookProduct", paramType = "body")})
    @RequestMapping(value = "create4Wechat", method = RequestMethod.POST)
    public ResponseDto<BookProductDto> create4Wechat(@CookieValue("userInfo") String userInfo,
                                                     @RequestBody BookProduct bookProduct) throws BizException, PermissionException, JsonParseException;

    /**
     * 删除书籍作品关联关系
     *
     * @param token
     * @param bookId
     * @param appId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "删除书籍作品关联关系", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "productId", value = "作品标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "delete", method = RequestMethod.GET)
    public ResponseDto<?> delete(@RequestHeader("token") String token,
                                 @RequestParam(value = "bookId", required = false) Long bookId,
                                 @RequestParam(value = "productId", required = false) Long productId,
                                 @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端删除书籍作品关联关系
     *
     * @param token
     * @param bookId
     * @param appId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "微信端删除书籍作品关联关系", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "productId", value = "作品标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "delete4Wechat", method = RequestMethod.GET)
    public ResponseDto<?> delete4Wechat(@CookieValue("userInfo") String userInfo,
                                        @RequestParam(value = "bookId", required = false) Long bookId,
                                        @RequestParam(value = "productId", required = false) Long productId,
                                        @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍关联的作品
     *
     * @param token
     * @param bookId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取书籍关联的作品", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "listById", method = RequestMethod.GET)
    public ResponseDto<List<BookProductDto>> getListById(@RequestHeader("token") String token,
                                                         @RequestParam(value = "bookId", required = false) Long bookId,
                                                         @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍关联的作品(pc-编辑)
     *
     * @param token
     * @param bookId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取书籍关联的作品(pc-编辑)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "list4Adviser", method = RequestMethod.GET)
    public ResponseDto<List<BookProductDto>> list4Adviser(@RequestHeader("token") String token,
                                                          @RequestParam(value = "bookId", required = false) Long bookId,
                                                          @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 设置录音
     *
     * @param token
     * @param bookId    图书标识
     * @param channelId 渠道标识
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "设置录音", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookProduct", value = "书籍作品实体", dataType = "BookProduct", paramType = "body")})
    @RequestMapping(value = "setSound", method = RequestMethod.POST)
    public ResponseDto<?> setSound(@RequestHeader("token") String token, @RequestBody BookProduct bookProduct)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 设置录音
     *
     * @param token
     * @param bookId    图书标识
     * @param channelId 渠道标识
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "微信端设置录音", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookProduct", value = "书籍作品实体", dataType = "BookProduct", paramType = "body")})
    @RequestMapping(value = "setSound4Wechat", method = RequestMethod.POST)
    public ResponseDto<?> setSound4Wechat(@CookieValue("userInfo") String userInfo,
                                          @RequestBody BookProduct bookProduct) throws BizException, PermissionException, JsonParseException;

    /**
     * 更新商品类型
     *
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "更新商品类型", httpMethod = "GET")
    @RequestMapping(value = "updateProductType", method = RequestMethod.GET)
    public ResponseDto<?> updateProductType() throws BizException, PermissionException, JsonParseException;

    /**
     * 获取图书关联超级作者商品个数
     *
     * @param token
     * @param bookId
     * @param channelId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取图书关联超级作者商品个数", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getSuperProCount", method = RequestMethod.GET)
    ResponseDto<CountDto> getSuperProCount(@RequestHeader("token") String token,
                                           @RequestParam(value = "bookId", required = false) Long bookId,
                                           @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取图书关联商品个数
     *
     * @param token
     * @param bookId
     * @param channelId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取图书关联商品个数", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getProCount", method = RequestMethod.GET)
    ResponseDto<CountDto> getProCount(@RequestHeader("token") String token,
                                      @RequestParam(value = "bookId", required = false) Long bookId,
                                      @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍关联作品-出版端
     *
     * @param token
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     * @throws BizException
     * @throws PermissionException
     * @throws JsonParseException
     */
    @ApiOperation(value = "获取书籍关联作品-出版端", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "list4Agent", method = RequestMethod.GET)
    ResponseDto<List<BookProductDto>> list4Agent(@RequestHeader("token") String token,
                                                 @RequestParam(value = "bookId", required = false) Long bookId,
                                                 @RequestParam(value = "adviserId", required = false) Long adviserId,
                                                 @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

}
