package com.pcloud.book.book.facade.impl;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.pcloud.book.book.biz.BookFreezeBiz;
import com.pcloud.book.book.dto.BookFreezeDto;
import com.pcloud.book.book.entity.BookFreeze;
import com.pcloud.book.book.entity.ThawEarning;
import com.pcloud.book.book.facade.BookFreezeFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

/**
 * 图书冻结接口实现类
 * 
 * @author lili
 * @date 2018/1/18 18:13
 */
@RequestMapping("/bookFreeze")
@RestController("bookFreezeFacade")
@Produces({ ContentType.APPLICATION_JSON_UTF_8 })
@Consumes({ MediaType.APPLICATION_JSON })
public class BookFreezeFacadeImpl implements BookFreezeFacade {
	@Autowired
	private BookFreezeBiz bookFreezeBiz;

	/**
	 * 冻结收益
	 */
	@Override
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<?> create(@RequestHeader("token") String token, @RequestBody BookFreeze bookFreeze)
			throws BizException, PermissionException, JsonParseException {
		Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookFreeze.setCreatedUser(partyId);
		bookFreezeBiz.create(bookFreeze);
		return new ResponseDto<>();
	}

	/**
	 * 获取冻结信息
	 */
	@Override
	@RequestMapping(value = "getBaseById", method = RequestMethod.GET)
	public ResponseDto<BookFreezeDto> getBaseById(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		BookFreezeDto bookFreezeDto = bookFreezeBiz.getBaseById(bookId);
		return new ResponseDto<>(bookFreezeDto);
	}

	/**
	 * 获取冻结信息（微信端）
	 */
	@Override
	@RequestMapping(value = "getBaseById4Wechat", method = RequestMethod.GET)
	public ResponseDto<BookFreezeDto> getBaseById4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException {
		Cookie.getId(userInfo, Cookie._PARTY_ID);
		BookFreezeDto bookFreezeDto = bookFreezeBiz.getBaseById(bookId);
		return new ResponseDto<>(bookFreezeDto);
	}

	/**
	 * 解冻收益
	 */
	@Override
	@RequestMapping(value = "thaw", method = RequestMethod.POST)
	public ResponseDto<?> thaw(@RequestHeader("token") String token, @RequestBody ThawEarning thawEarning)
			throws BizException, PermissionException, JsonParseException {
		Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookFreezeBiz.thaw(thawEarning, partyId);
		return new ResponseDto<>();
	}
}
