package com.pcloud.book.book.facade.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.pcloud.book.book.biz.BookFundBiz;
import com.pcloud.book.book.dto.BookFundDto;
import com.pcloud.book.book.entity.BookFund;
import com.pcloud.book.book.facade.BookFundFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

/**
 * @描述：书刊基金接口实现层
 * @作者：lihao
 * @创建时间：2017年7月19日,下午3:14:10 @版本：1.0
 */
@RequestMapping("/bookFund")
@RestController("bookFundFacade")
@Produces({ ContentType.APPLICATION_JSON_UTF_8 })
@Consumes({ MediaType.APPLICATION_JSON })
public class BookFundFacadeImpl implements BookFundFacade {

	@Autowired
	private BookFundBiz bookFundBiz;

	/**
	 * 创建书刊基金状态
	 */
	@Override
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<?> create(@RequestHeader("token") String token, @RequestBody BookFund bookFund)
			throws BizException, PermissionException, JsonParseException {
		Long userId = (Long) SessionUtil.getVlaue(token, SessionUtil.USER_ID);
		// 实体赋值
		bookFund.setCreatedUser(userId);
		bookFundBiz.create(bookFund);
		return new ResponseDto<>();
	}

	/**
	 * 修改书刊基金状态
	 */
	@Override
	@RequestMapping(value = "update", method = RequestMethod.POST)
	public ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody BookFund bookFund)
			throws BizException, PermissionException, JsonParseException {
		Long userId = (Long) SessionUtil.getVlaue(token, SessionUtil.USER_ID);
		// 实体赋值
		bookFund.setLastModifiedUser(userId);
		bookFundBiz.update(bookFund);
		return new ResponseDto<>();
	}

	/**
	 * 根据BookId获取基金状态
	 */
	@Override
	@RequestMapping(value = "getByBookId", method = RequestMethod.GET)
	public ResponseDto<?> getByBookId(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		List<BookFundDto> bookFundDtos = bookFundBiz.getByBookId(bookId);
		return new ResponseDto<List<BookFundDto>>(bookFundDtos == null ? new ArrayList<BookFundDto>() : bookFundDtos);
	}

	/**
	 * 编辑端获取书刊基金买断信息
	 */
	@Override
	@RequestMapping(value = "getFundList4Adviser", method = RequestMethod.GET)
	public ResponseDto<?> getFundList4Adviser(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);

		return new ResponseDto<Map<String, Object>>(bookFundBiz.getFundList4Adviser(bookId));
	}

	/**
	 * 分页获取基金图书状态
	 */
	@Override
	@RequestMapping(value = "listByBookId", method = RequestMethod.GET)
	public ResponseDto<?> listByBookId(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "currentPage", required = false) Integer currentPage,
			@RequestParam(value = "numPerPage", required = false) Integer numPerPage)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		PageBean pageBean = bookFundBiz.listByBookId(new PageParam(currentPage, numPerPage), bookId);
		return new ResponseDto<PageBean>(pageBean == null ? new PageBean() : pageBean);
	}

	/**
	 * 获取书刊基金状态
	 */
	@RequestMapping(value = "getByBookFundId", method = RequestMethod.GET)
	public ResponseDto<?> getByBookFundId(@RequestHeader("token") String token,
			@RequestParam(value = "bookFundId", required = false) Long bookFundId)
			throws BizException, PermissionException, JsonParseException {
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		return new ResponseDto<>(bookFundBiz.getByBookFundId(bookFundId));
	}

	/**
	 * 删除书刊基金
	 */
	@Override
	@RequestMapping(value = "deleteById", method = RequestMethod.GET)
	public ResponseDto<?> deleteById(@RequestParam(value = "bookFundId", required = false) Long bookFundId)
			throws BizException, PermissionException, JsonParseException {
		bookFundBiz.deleteById(bookFundId);
		return new ResponseDto<>();
	}

}
