package com.pcloud.book.book.facade.impl;

import java.util.ArrayList;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.codehaus.jackson.JsonParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.dubbo.rpc.protocol.rest.support.ContentType;
import com.pcloud.book.base.dto.CountDto;
import com.pcloud.book.book.biz.BookResourceBiz;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.BookResourceDto;
import com.pcloud.book.book.entity.BookResource;
import com.pcloud.book.book.facade.BookResourceFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

/**
 * 书籍资源
 * 
 * @author:lili
 * @date 创建时间：2017年3月17日 下午4:04:44
 * @version 1.0
 * @return
 */
@RequestMapping("/bookResource")
@RestController("bookResourceFacade")
@Produces({ ContentType.APPLICATION_JSON_UTF_8 })
@Consumes({ MediaType.APPLICATION_JSON })
public class BookResourceFacadeImpl implements BookResourceFacade {
	@Autowired
	private BookResourceBiz bookResourceBiz;

	/**
	 * 添加书籍和应用关联关系
	 */
	@Override
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public ResponseDto<BookResourceDto> create(@RequestHeader("token") String token,
			@RequestBody BookResource bookResource) throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookResource.setCreatedUser(adviserId);
		// 添加
		bookResourceBiz.create(bookResource);

		BookResourceDto bookResourceDto = new BookResourceDto();
		bookResourceDto.setBookResourceId(bookResource.getBookResourceId());
		return new ResponseDto<>(bookResourceDto);
	}

	/**
	 * 微信端添加书籍和应用关联关系
	 */
	@Override
	@RequestMapping(value = "create4Wechat", method = RequestMethod.POST)
	public ResponseDto<BookResourceDto> create4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestBody BookResource bookResource) throws BizException, PermissionException, JsonParseException {
		// token
		Long adviserId = Cookie.getId(userInfo, Cookie._PARTY_ID);
		bookResource.setCreatedUser(adviserId);
		// 添加
		bookResourceBiz.create(bookResource);

		BookResourceDto bookResourceDto = new BookResourceDto();
		bookResourceDto.setBookResourceId(bookResource.getBookResourceId());
		return new ResponseDto<>(bookResourceDto);
	}

	/**
	 * 删除书籍应用关联关系
	 */
	@Override
	@RequestMapping(value = "delete", method = RequestMethod.GET)
	public ResponseDto<?> delete(@RequestHeader("token") String token,
			@RequestParam(value = "bookResourceId", required = false) Long bookResourceId)
			throws BizException, PermissionException, JsonParseException {
		// token
		SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		bookResourceBiz.delete(bookResourceId);
		return new ResponseDto<>();
	}

	/**
	 * 微信端删除书籍应用关联关系
	 */
	@Override
	@RequestMapping(value = "delete4Wechat", method = RequestMethod.GET)
	public ResponseDto<?> delete4Wechat(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookResourceId", required = false) Long bookResourceId)
			throws BizException, PermissionException, JsonParseException {
		// token
		Cookie.getId(userInfo, Cookie._PARTY_ID);
		bookResourceBiz.delete(bookResourceId);
		return new ResponseDto<>();
	}

	/**
	 * 获取书籍关联的资源
	 */
	@Override
	@RequestMapping(value = "listById", method = RequestMethod.GET)
	public ResponseDto<BookDto> getListById(@CookieValue("userInfo") String userInfo,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "adviserId", required = false) Long adviserId)
			throws BizException, PermissionException, JsonParseException {
		// token
		Long channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
		return new ResponseDto<>(bookResourceBiz.getResouceByBook(bookId, adviserId, channelId));
	}

	/**
	 * 获取图书关联资源个数
	 */
	@Override
	@RequestMapping(value = "getResourceCount", method = RequestMethod.GET)
	public ResponseDto<CountDto> getResourceCount(@RequestHeader("token") String token,
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId)
			throws BizException, PermissionException, JsonParseException {
		Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
		Integer count = bookResourceBiz.getResourceCount(adviserId, bookId, channelId);
		CountDto countDto = new CountDto();
		countDto.setCount(count);
		return new ResponseDto<>(countDto);
	}

	/**
	 * 获取图书关联资源-代理
	 */
	@Override
	@RequestMapping(value = "listById4Agent", method = RequestMethod.GET)
	public ResponseDto<List<BookResourceDto>> listById4Agent(@RequestHeader("token") String token,
			@RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
			@RequestParam("adviserId") Long adviserId) throws BizException, PermissionException, JsonParseException {
		List<BookResourceDto> resourceFiles = bookResourceBiz.listById4Agent(bookId, adviserId, channelId);
		return new ResponseDto<>(resourceFiles == null ? new ArrayList<BookResourceDto>() : resourceFiles);
	}

}
