/**
 * 
 */
package com.pcloud.book.consumer.raystask;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.raystask.entity.AdviserDefault;
import com.pcloud.raystask.task.service.MainLineService;

/**
 * @描述：
 * @作者：songx
 * @创建时间：2017年4月20日,上午10:26:44
 * @版本：1.0
 */
@Component("mainLineConsr")
public class MainLineConsr {
	
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(MainLineConsr.class);
	
	@Autowired
	private MainLineService mainLineService;

	/**
	 * 设置默认应用标识
	 */
	public void sendDefaultId(AdviserDefault adviserDefault) throws BizException {
		LOGGER.info("【rays小游戏(消)】设置默认应用标识,<START>");
		try {
			mainLineService.sendDefaultId(adviserDefault);
		} catch (Exception e) {
			LOGGER.error("【rays小游戏(消)】设置默认应用标识.[sendDefaultId]:" + e.getMessage(), e);
		}
	}

}
