/**
 * 
 */
package com.pcloud.book.consumer.user;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.pcloud.usercenter.user.service.UserLoginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.usercenter.party.agent.entity.Agent;
import com.pcloud.usercenter.party.common.service.PartyService;

/**
 * @描述：当事人中间类
 * @作者：songx
 * @创建时间：2016年11月28日,下午3:46:01 @版本：1.0
 */
@Component("partyConsr")
public class PartyConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(PartyConsr.class);

	@Autowired
	private PartyService partyService;
	@Autowired
	private UserLoginService userLoginService;

	/**
	 * 批量获取代理基本信息
	 */
	public Map<Long, Agent> getAgentByPartyId(List<Long> partyIds, String roleCode) throws BizException {
		LOGGER.info("【用户中心(消)】批量获取代理基本信息,<START>.[partyIds]=" + partyIds.toString());
		if (ListUtils.isEmpty(partyIds)) {
			return null;
		}
		Map<Long, Agent> agentInfoMap = ResponseHandleUtil
				.parseMapResponse(partyService.getAgentByPartyId(partyIds, roleCode), Long.class, Agent.class);
		LOGGER.info("【用户中心(消)】批量获取代理基本信息,<END>");
		return agentInfoMap;
	}

	/**
	 * 获取平台端所有账号的用户名
	 */
	public Map<Long, String> getAllUserLoginName(Long partyId, String systemCode) throws BizException {
		LOGGER.info("【用户中心(消)】获取平台端所有账号的用户名,<START>.[partyId]=" + partyId + ", [systemCode]=" + systemCode);
		if (null == partyId || null == systemCode) {
			return new HashMap<>();
		}
		Map<Long, String> resultMap = ResponseHandleUtil
				.parseMapResponse(userLoginService.getAllUserLoginName(partyId, systemCode), Long.class, String.class);
		LOGGER.info("【用户中心(消)】获取平台端所有账号的用户名,<END>.result = " + resultMap.toString());
		return resultMap;
	}

}
