package com.pcloud.common.core.aspect;

import java.util.Arrays;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

import com.alibaba.fastjson.JSON;

/**
 * 
 * 
 * @author：songx
 * @date：2018年1月23日,上午11:34:42
 */
@Aspect
@Configuration
public class BaseBizAspect {

	/**
	 * 
	 */
	private final static Logger LOGGER = LoggerFactory.getLogger(BaseBizAspect.class);

	@Pointcut("execution(* com.pcloud.*.*.biz.impl.*Impl.*(..))")
	public void bizPoint() {
	}

	/**
	 * 方法执行前以后执行,暂时不提供使用，日志会比较多
	 * 
	 * @param joinPoint
	 */
	@Before("bizPoint()")
	public void doBefore(JoinPoint joinPoint) {
		boolean bool = false;
		if (bool)
			LOGGER.info("【Biz Aspect】Before.[signature]=" + joinPoint.getSignature().toString() + ",[args]="
					+ Arrays.toString(joinPoint.getArgs()));
	}

	/**
	 * 方法执行完以后执行,暂时不提供使用，日志会比较多
	 * 
	 * @param object
	 */
	@AfterReturning(pointcut = "bizPoint()", returning = "result")
	public void doAfterReturn(JoinPoint joinPoint, Object result) {
		boolean bool = false;
		if (bool)
			LOGGER.info("【Biz Aspect】AfterReturning.[signature]=" + joinPoint.getSignature().toString() + ",[result]="
					+ JSON.toJSONString(result));
	}

}
