package com.pcloud.book.advertising.enums;

/**
 * Description 具体广告位置枚举
 * @author PENG
 * @date 2019/4/24
 */
public enum AdPositionDetailEnum {

    JOIN_PAGE(AdPositionEnum.BOOK_GROUP_PAGE.positionCode, "JOIN_PAGE", "入群选择页"),

    GROUP_QRCODE_PAGE(AdPositionEnum.BOOK_GROUP_PAGE.positionCode, "GROUP_QRCODE_PAGE", "群二维码页面"),

    FAIL_JOIN_PAGE(AdPositionEnum.BOOK_GROUP_PAGE.positionCode, "FAIL_JOIN_PAGE", "群成员已满/无法入群页面");

    public final String positionCode;
    public final String detailCode;
    public final String detailName;

    AdPositionDetailEnum(String positionCode, String detailCode, String detailName) {
        this.positionCode = positionCode;
        this.detailCode = detailCode;
        this.detailName = detailName;
    }

    /**
     * 校验位置是否存在
     */
    public static Boolean checkCodeExist(String positionCode, String detailCode) {
        AdPositionDetailEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdPositionDetailEnum adPositionDetailEnum = var1[var3];
            if (adPositionDetailEnum.positionCode.equals(positionCode) && adPositionDetailEnum.detailCode.equals(detailCode)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 根据编码拿名称
     */
    public static String getNameByCode(String detailCode) {
        AdPositionDetailEnum[] var1 = values();
        int var2 = var1.length;
        for (int var3 = 0; var3 < var2; ++var3) {
            AdPositionDetailEnum adPositionDetailEnum = var1[var3];
            if (adPositionDetailEnum.detailCode.equals(detailCode)) {
                return adPositionDetailEnum.detailName;
            }
        }
        return "";
    }
}
