package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletBannerBiz;
import com.pcloud.book.applet.biz.AppletBooklistBiz;
import com.pcloud.book.applet.biz.AppletNewsBiz;
import com.pcloud.book.applet.biz.AppletUserBookcaseBiz;
import com.pcloud.book.applet.dto.AddBookParamDTO;
import com.pcloud.book.applet.dto.AppletBannerDTO;
import com.pcloud.book.applet.dto.AppletBooklistClassifyDTO;
import com.pcloud.book.applet.dto.AppletBooklistDTO;
import com.pcloud.book.applet.dto.AppletNewsClassifyDTO;
import com.pcloud.book.applet.dto.AppletNewsCommentDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.dto.BookDTO4Booklist;
import com.pcloud.book.applet.entity.AppletBanner;
import com.pcloud.book.applet.entity.AppletBooklist;
import com.pcloud.book.applet.entity.AppletBooklistClassify;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.book.applet.entity.AppletNewsClassify;
import com.pcloud.book.applet.entity.AppletNewsComment;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.applet.entity.AppletUserClickRecord;
import com.pcloud.book.applet.vo.AppletNewsClassifyVO;
import com.pcloud.book.applet.vo.AppletNewsShowStateVO;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.skill.biz.PcloudGroupActivityBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import com.pcloud.common.utils.string.StringUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

@Api("小睿小程序首页")
@RestController("appletHomeFacade")
@RequestMapping("appletHome")
public class AppletHomeFacade {

    @Autowired
    private AppletBooklistBiz appletBooklistBiz;
    @Autowired
    private AppletBannerBiz appletBannerBiz;
    @Autowired
    private AppletNewsBiz appletNewsBiz;
    @Autowired
    private AppletUserBookcaseBiz appletUserBookcaseBiz;
    @Autowired
    private PcloudGroupActivityBiz pcloudGroupActivityBiz;

    @ApiOperation("新增书单栏目")
    @PostMapping("addBooklistClassify")
    public ResponseDto<Long> addBooklistClassify(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("书单栏目") AppletBooklistClassify appletBooklistClassify) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletBooklistClassify || StringUtil.isEmpty(appletBooklistClassify.getClassifyName())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少栏目名称");
        }
        Long id = appletBooklistBiz.addBooklistClassify(appletBooklistClassify);
        return new ResponseDto<>(id);
    }

    @ApiOperation("删除书单栏目")
    @GetMapping("deleteBooklistClassifyById")
    public ResponseDto<?> deleteBooklistClassifyById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("书刊栏目id") Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少栏目id");
        }
        appletBooklistBiz.deleteBooklistClassifyById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("修改书单栏目")
    @PostMapping("updateBooklistClassify")
    public ResponseDto<?> updateBooklistClassify(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("书单栏目")AppletBooklistClassify appletBooklistClassify) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null ==appletBooklistClassify || null==appletBooklistClassify.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletBooklistBiz.updateBooklistClassify(appletBooklistClassify);
        return new ResponseDto<>();
    }

    @ApiOperation("书单栏目列表")
    @GetMapping("listBooklistClassify")
    public ResponseDto<PageBeanNew<AppletBooklistClassifyDTO>> listBooklistClassify(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称查询") String name) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBooklistBiz.listBooklistClassify(currentPage, numPerPage, name));
    }

    @ApiOperation("新增书单")
    @PostMapping("addBooklist")
    public ResponseDto<Long> addBooklist(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("书单") AppletBooklist appletBooklist) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletBooklist){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        Long id = appletBooklistBiz.addBooklist(appletBooklist);
        return new ResponseDto<>(id);
    }

    @ApiOperation("删除书单")
    @GetMapping("deleteBooklistById")
    public ResponseDto<?> deleteBooklistById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("书刊id")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少书刊id");
        }
        appletBooklistBiz.deleteBooklistById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("修改书单")
    @PostMapping("updateBooklist")
    public ResponseDto<?> updateBooklist(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("书单") AppletBooklist appletBooklist) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletBooklist || null == appletBooklist.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletBooklistBiz.updateBooklist(appletBooklist);
        return new ResponseDto<>();
    }

    @ApiOperation("根据id查书单")
    @GetMapping("getBooklistById")
    public ResponseDto<AppletBooklistDTO> getBooklistById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("书刊id")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少书刊id");
        }
        return new ResponseDto<>(appletBooklistBiz.getBooklistById(id));
    }

    @ApiOperation("书单管理列表")
    @GetMapping("listBooklist")
    public ResponseDto<PageBeanNew<AppletBooklistDTO>> listBooklist(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称查询") String name) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBooklistBiz.listBooklist(currentPage, numPerPage, name));
    }

    @ApiOperation("书单添加图书")
    @PostMapping("addBookToBooklist")
    public ResponseDto<?> addBookToBooklist(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("添加图书参数") AddBookParamDTO addBookParamDTO) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == addBookParamDTO || null == addBookParamDTO.getBooklistId() || ListUtils.isEmpty(addBookParamDTO.getBookDTO4Booklists())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        for (BookDTO4Booklist bookDTO : addBookParamDTO.getBookDTO4Booklists()){
            if (null==bookDTO.getBookId() || null==bookDTO.getAdviserId() ||null == bookDTO.getChannelId()){
                throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少bookId/adviserId/channelId");
            }
        }
        appletBooklistBiz.addBookToBooklist(addBookParamDTO);
        return new ResponseDto<>();
    }

    @ApiOperation("新增banner")
    @PostMapping("addBanner")
    public ResponseDto<Long> addBanner(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("banner") AppletBanner appletBanner) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletBanner){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        Long id = appletBannerBiz.addBanner(appletBanner);
        return new ResponseDto<>(id);
    }

    @ApiOperation("修改banner")
    @PostMapping("updateBanner")
    public ResponseDto<?> updateBanner(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("banner") AppletBanner appletBanner) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletBanner || null == appletBanner.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletBannerBiz.updateBanner(appletBanner);
        return new ResponseDto<>();
    }

    @ApiOperation("删除banner")
    @GetMapping("deleteBanner")
    public ResponseDto<?> deleteBanner(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("bannerId")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少bannerId");
        }
        appletBannerBiz.deleteBanner(id);
        return new ResponseDto<>();
    }

    @ApiOperation("根据id查banner")
    @GetMapping("getBannerById")
    public ResponseDto<AppletBannerDTO> getBannerById(
            @RequestHeader("token") String token,
            @RequestParam("bannerId") @ApiParam("bannerId")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少bannerId");
        }
        return new ResponseDto<>(appletBannerBiz.getBannerById(id));
    }

    @ApiOperation("banner列表")
    @GetMapping("listBanner")
    public ResponseDto<PageBeanNew<AppletBannerDTO>> listBanner(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBannerBiz.listBanner(currentPage, numPerPage,null));
    }

    @ApiOperation("客户端banner列表")
    @GetMapping("listBanner4Wechat")
    public ResponseDto<PageBeanNew<AppletBannerDTO>> listBanner4Wechat(
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage) {
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBannerBiz.listBanner(currentPage, numPerPage, true));
    }

    @ApiOperation("获取书单下书籍列表")
    @GetMapping("listPageBook4AppletBooklist")
    public ResponseDto<PageBeanNew<BookDTO4Booklist>> listPageBook4AppletBooklist(
            @RequestHeader("token") String token,
            @RequestParam("booklistId") @ApiParam("书单id") Long booklistId,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==booklistId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少书单id");
        }
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBooklistBiz.listPageBook4AppletBooklist(booklistId,currentPage,numPerPage));
    }

    @ApiOperation("更新书籍排序")
    @GetMapping("updateBookSeq")
    public ResponseDto<?> updateBookSeq(
            @RequestHeader("token") String token,
            @RequestParam("configId") @ApiParam("配置id") Long configId,
            @RequestParam("seq") @ApiParam("排序值")Integer seq) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==configId || null == seq){
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "缺少参数");
        }
        appletBooklistBiz.updateBookSeq(configId, seq);
        return new ResponseDto<>();
    }

    @ApiOperation("获取所有书单栏目")
    @GetMapping("getAllBooklistClassify")
    public ResponseDto<List<AppletBooklistClassifyDTO>> getAllBooklistClassify(
            @RequestParam(value = "showState", required = false) @ApiParam("是否展示") Boolean showState){
        return new ResponseDto<>(appletBooklistBiz.getAllBooklistClassify(showState));
    }

    @ApiOperation("客户端获取书单列表")
    @GetMapping("listBooklist4Wechat")
    public ResponseDto<PageBeanNew<AppletBooklistDTO>> listBooklist4Wechat(
            @RequestParam(value = "classifyId", required = false) @ApiParam("书单栏目id") Long classifyId,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage){
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletBooklistBiz.listBooklist4Wechat(classifyId,currentPage,numPerPage));
    }

    @ApiOperation("客户端根据id获取书单")
    @GetMapping("getBooklistById4Wechat")
    public ResponseDto<AppletBooklistDTO> getBooklistById4Wechat(
            @RequestParam("booklistId") @ApiParam("书单id")Long booklistId){
        if (null==booklistId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletBooklistBiz.getBooklistById4Wechat(booklistId));
    }

    @ApiOperation("新增资讯栏目")
    @PostMapping("addAppletNewsClassify")
    public ResponseDto<Long> addAppletNewsClassify(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯栏目") AppletNewsClassify appletNewsClassify) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNewsClassify){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletNewsBiz.addAppletNewsClassify(appletNewsClassify));
    }

    @ApiOperation("修改资讯栏目")
    @PostMapping("updateAppletNewsClassify")
    public ResponseDto<?> updateAppletNewsClassify(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯栏目")AppletNewsClassify appletNewsClassify) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNewsClassify || null == appletNewsClassify.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.updateAppletNewsClassify(appletNewsClassify);
        return new ResponseDto<>();
    }

    @ApiOperation("删除资讯栏目")
    @GetMapping("deleteNewsClassifyById")
    public ResponseDto<?> deleteNewsClassifyById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("资讯栏目")Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.deleteNewsClassifyById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("资讯栏目列表")
    @GetMapping("listNewsClassify")
    public ResponseDto<PageBeanNew<AppletNewsClassifyDTO>> listNewsClassify(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称查询") String name) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletNewsBiz.listNewsClassify(currentPage, numPerPage, name));
    }

    @ApiOperation("获取所有资讯栏目")
    @GetMapping("getAllNewsClassify")
    public ResponseDto<List<AppletNewsClassifyDTO>> getAllNewsClassify(
            @RequestParam(value = "showState", required = false) @ApiParam("是否展示") Boolean showState){
        return new ResponseDto<>(appletNewsBiz.getAllNewsClassify(showState));
    }

    @ApiOperation("添加资讯")
    @PostMapping("addAppletNews")
    public ResponseDto<Long> addAppletNews(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯") AppletNews appletNews) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNews){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletNewsBiz.addAppletNews(appletNews));
    }

    @ApiOperation("修改资讯")
    @PostMapping("updateAppletNews")
    public ResponseDto<?> updateAppletNews(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯") AppletNews appletNews) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNews || null == appletNews.getId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.updateAppletNews(appletNews);
        return new ResponseDto<>();
    }

    @ApiOperation("删除资讯")
    @GetMapping("deleteAppletNewsById")
    public ResponseDto<?> deleteAppletNewsById(
            @RequestHeader("token") String token,
            @RequestParam("id") @ApiParam("资讯id") Long id) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == id){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.deleteAppletNewsById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("资讯列表")
    @GetMapping("listAppletNews")
    public ResponseDto<PageBeanNew<AppletNewsDTO>> listAppletNews(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("名称查询") String name,
            @RequestParam(value = "firstClassify", required = false) @ApiParam("一级书刊分类") Long firstClassify,
            @RequestParam(value = "secondClassify", required = false) @ApiParam("二级书刊分类")Long secondClassify,
            @RequestParam(value = "gradeLabelId", required = false) @ApiParam("年级标签")Long gradeLabelId,
            @RequestParam(value = "subjectLabelId", required = false) @ApiParam("科目标签")Long subjectLabelId,
            @RequestParam(value = "rightsClassifyId", required = false) @ApiParam("权益分类") Long rightsClassifyId,
            @RequestParam(value = "source", required = false) @ApiParam("来源") String source
            ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletNewsBiz.listAppletNews(currentPage, numPerPage, name, firstClassify,secondClassify,gradeLabelId,
                subjectLabelId,rightsClassifyId,source));
    }

    @ApiOperation("客户端资讯列表")
    @GetMapping("listAppletNews4Wechat")
    public ResponseDto<PageBeanNew<AppletNewsDTO>> listAppletNews4Wechat(
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam(value = "newsClassifyId", required = false) @ApiParam("资讯栏目id") Long newsClassifyId) {
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletNewsBiz.listAppletNews4Wechat(currentPage, numPerPage, newsClassifyId));
    }

    @ApiOperation("添加资讯评论")
    @PostMapping("addAppletNewsComment")
    public ResponseDto<?> addAppletNewsComment(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("资讯评论") AppletNewsComment appletNewsComment){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null==appletNewsComment || null == appletNewsComment.getNewsId() || StringUtil.isEmpty(appletNewsComment.getComment())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.addAppletNewsComment(appletNewsComment,wechatUserId);
        return new ResponseDto<>();
    }

    @ApiOperation("查询资讯评论列表")
    @GetMapping("listNewsCommentByNewsId")
    public ResponseDto<PageBeanNew<AppletNewsCommentDTO>> listNewsCommentByNewsId(
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage,
            @RequestParam("newsId") @ApiParam("资讯id") Long newsId){
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        if (null == newsId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少资讯id");
        }
        return new ResponseDto<>(appletNewsBiz.listNewsCommentByNewsId(currentPage, numPerPage, newsId));
    }

    @ApiOperation("添加图书到书架")
    @PostMapping("addUserBook")
    public ResponseDto<?> addUserBook(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("图书") AppletUserBookcase appletUserBookcase){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == appletUserBookcase || null == appletUserBookcase.getBookId() || null == appletUserBookcase.getAdviserId()
            || null == appletUserBookcase.getChannelId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletUserBookcase.setWechatUserId(wechatUserId);
        appletUserBookcaseBiz.addUserBook(appletUserBookcase);
        return new ResponseDto<>();
    }

    @ApiOperation("查用户书架列表")
    @GetMapping("listUserBookcaseByWechatUserId")
    public ResponseDto<PageBeanNew<AppletUserBookcaseDTO>> listUserBookcaseByWechatUserId(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量") Integer numPerPage){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null==currentPage || null == numPerPage){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少分页参数");
        }
        return new ResponseDto<>(appletUserBookcaseBiz.listByWechatUserId(wechatUserId,currentPage,numPerPage));
    }

    @ApiOperation("新增用户资源点击记录")
    @PostMapping("addUserClickRecord")
    public ResponseDto<?>  addUserClickRecord(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("资源点击记录") AppletUserClickRecord appletUserClickRecord){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == appletUserClickRecord || null == appletUserClickRecord.getBookId()
            || null == appletUserClickRecord.getFromId() ||StringUtil.isEmpty(appletUserClickRecord.getFromType())){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletUserClickRecord.setWechatUserId(wechatUserId);
        appletUserBookcaseBiz.addUserClickRecord(appletUserClickRecord);
        return new ResponseDto<>();
    }

    @ApiOperation("用户图书资源点击统计")
    @GetMapping("getUserClickStatistic")
    public ResponseDto<Map<String,Object>> getUserClickStatistic(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("bookId") @ApiParam("图书id")Long bookId,
            @RequestParam("channelId") @ApiParam("运营id")Long channelId,
            @RequestParam("adviserId") @ApiParam("编辑id")Long adviserId){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == bookId || null== channelId || null == adviserId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletUserBookcaseBiz.getUserClickStatistic(wechatUserId,bookId,channelId,adviserId));
    }

    @ApiOperation("根据ID查资讯详情")
    @GetMapping("getAppletNewsById")
    public ResponseDto<AppletNewsDTO> getAppletNewsById(
            @RequestParam("newsId") @ApiParam("资讯id")Long newsId){
        if (null == newsId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletNewsBiz.getNewsById(newsId));
    }

    @ApiOperation("查图书详情-出版作者分类书名")
    @GetMapping("getByBookIdAdviserChannel")
    public ResponseDto<BookDTO4Booklist> getByBookIdAdviserChannel(
            @RequestParam("adviserId") @ApiParam("编辑id")Long adviserId,
            @RequestParam("channelId") @ApiParam("运营id")Long channelId,
            @RequestParam("bookId") @ApiParam("图书id")Long bookId){
        if (null == bookId || null== channelId || null == adviserId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(appletBooklistBiz.getByBookIdAdviserChannel(adviserId, channelId, bookId));
    }

    @ApiOperation("更新资讯上架状态")
    @PostMapping("updateNewsShowState")
    public ResponseDto<?> updateNewsShowState(
            @RequestHeader("token") String token,
            @RequestBody @ApiParam("资讯") AppletNews appletNews) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNews || null == appletNews.getId() || null == appletNews.getShowState()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.updateNewsShowState(appletNews);
        return new ResponseDto<>();
    }

    @ApiOperation("获取用户最后一次点击的书（有社群书的取最后一次社群书，没有的取现代纸书）")
    @GetMapping("getUserLastBookRe")
    public ResponseDto<?> getUserLastBookRe(
            @CookieValue("userInfo") String userInfo
    ) throws PermissionException{
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletUserBookcaseBiz.getUserLastBookRe(wechatUserId));
    }

    @ApiOperation("获取社群共读")
    @GetMapping("getGroupActivity4Applet")
    public ResponseDto<?> getGroupActivity4Applet(
        @CookieValue("userInfo") String userInfo,
        @RequestParam(value = "adviserId") Long adviserId,
        @RequestParam(value = "bookId") Long bookId,
        @RequestParam(value = "rightsSettingId") Long rightsSettingId,
        @RequestParam(value = "channelId") Long channelId
        ) {
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        if (null == wechatUserId){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        return new ResponseDto<>(pcloudGroupActivityBiz.getGroupActivity4Applet(rightsSettingId, adviserId ,bookId, channelId));
    }

    @ApiOperation("资讯来源列表")
    @GetMapping("getNewsSourceList")
    public ResponseDto<List<String>> getNewsSourceList(){
        return new ResponseDto<>(appletNewsBiz.getNewsSourceList());
    }

    @ApiOperation("批量修改分类")
    @PostMapping("batchUpdateClassify")
    public ResponseDto<?> batchUpdateClassify(
        @RequestHeader("token") String token,
        @RequestBody AppletNewsClassifyVO appletNewsClassifyVO
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        appletNewsBiz.batchUpdateClassify(appletNewsClassifyVO);
        return new ResponseDto<>();
    }

    @ApiOperation("批量上下架")
    @PostMapping("batchUpdateShowState")
    public ResponseDto<?> batchUpdateShowState(
        @RequestHeader("token") String token,
        @RequestBody AppletNewsShowStateVO appletNewsShowStateVO
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (null == appletNewsShowStateVO || ListUtils.isEmpty(appletNewsShowStateVO.getAppletNewsIds()) || null == appletNewsShowStateVO.getShowState()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.batchUpdateShowState(appletNewsShowStateVO);
        return new ResponseDto<>();
    }

    @ApiOperation("批量删除")
    @PostMapping("batchDeleteAppletNews")
    public ResponseDto<?> batchDeleteAppletNews(
        @RequestHeader("token") String token,
        @RequestBody List<Long> appletNewsIds
    ) throws PermissionException {
        SessionUtil.getInfoToken4Redis(token);
        if (ListUtils.isEmpty(appletNewsIds)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少参数");
        }
        appletNewsBiz.batchDeleteAppletNews(appletNewsIds);
        return new ResponseDto<>();
    }

}



