package com.pcloud.book.skill.biz;

import com.pcloud.book.skill.dto.GroupActivity4AppletDTO;
import com.pcloud.book.skill.facade.request.QueryGroupActivityRequestVO;
import com.pcloud.book.skill.facade.request.SaveGroupActivityRequestVO;
import com.pcloud.book.skill.facade.request.UpdateGroupActivityRequestVO;
import com.pcloud.book.skill.facade.response.QueryGroupActivityResponseVO;
import com.pcloud.common.page.PageBeanNew;

import org.springframework.web.bind.annotation.RequestParam;

public interface PcloudGroupActivityBiz {

    /**
     * 保存共读活动
     */
    void saveGroupActivity(SaveGroupActivityRequestVO vo);

    /**
     * 修改共读活动
     */
    void updateGroupActivity(UpdateGroupActivityRequestVO vo);

    /**
     * 删除共读
     */
    void deleteGroupActivity(Long id, Long partyId);

    /**
     * 处理共读选取
     */
    void processGroup(String wxId, String robotWxId, Long id);

    /**
     * 获取共读活动列表（分页）
     */
    PageBeanNew<QueryGroupActivityResponseVO> queryGroupActivity(String name, Long proLabelId, Long purLabelId, Long depLabelId, Integer joinType,Long firstClassify,
                                                                 Long secondClassify,
                                                                 Long gradeLabelId,
                                                                 Long subjectLabelId ,Integer numPerPage, Integer currentPage);

    /**
     * 根据分类获取社群共读
     * @return
     */
    GroupActivity4AppletDTO getGroupActivity4Applet(Long rightSettingId, Long adviserId, Long bookId, Long channelId);
}
