/**
 *
 */
package com.pcloud.book.book.facade;

import com.pcloud.book.book.dto.BookAssocCount;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.entity.Book;
import com.pcloud.book.book.vo.ListNoAuthBookParam;
import com.pcloud.book.book.vo.ListNoAuthGroupBookParam;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;

import org.codehaus.jackson.JsonParseException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * @描述：书籍接口
 * @作者：songx
 * @创建时间：2016年12月23日,下午2:37:02 @版本：1.0
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookFacadeCloud", path = "book/v1.0/book")
@Api(description = "书籍接口外部服务")
public interface BookFacade {

    @ApiOperation(value = "新增书籍(平台)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "create", method = RequestMethod.POST)
    ResponseDto<BookDto> create(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException;

    @ApiOperation(value = "修改书籍信息(平台)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "update", method = RequestMethod.POST)
    ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException;

    @ApiOperation(value = "修改书籍封面图", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "updateCoverImg", method = RequestMethod.POST)
    ResponseDto<?> updateCoverImg(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "修改书籍信息(编辑)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "updateByAdviser", method = RequestMethod.POST)
    ResponseDto<?> updateByAdviser(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException;

    @ApiOperation(value = "删除书籍信息(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "delete", method = RequestMethod.GET)
    ResponseDto<?> delete(@RequestHeader("token") String token,
                          @RequestParam(value = "bookId") Long bookId)
            throws BizException, PermissionException;

    @ApiOperation(value = "批量删除书籍信息(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookIds", value = "图书标识", dataType = "string", paramType = "query")})
    @RequestMapping(value = "deletes", method = RequestMethod.GET)
    ResponseDto<?> deletes(@RequestHeader("token") String token,
                           @RequestParam(value = "bookIds") String bookIds)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取书籍基础信息(包含统计信息)（编辑端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getById", method = RequestMethod.GET)
    ResponseDto<BookDto> getById(@RequestHeader("token") String token,
                                 @RequestParam(value = "bookId") Long bookId,
                                 @RequestParam(value = "channelId") Long channelId)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取书籍基础信息", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getBaseById", method = RequestMethod.GET)
    ResponseDto<BookDto> getBaseById(@RequestParam(value = "bookId") Long bookId)
            throws BizException;

    @ApiOperation(value = "判断书籍ISBN码是否存在(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "typeCode", value = "书类型编码", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "书籍号", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "serialNumber", value = "刊物序号", dataType = "string", paramType = "query")})
    @RequestMapping(value = "isbnExists", method = RequestMethod.GET)
    ResponseDto<Boolean> isbnExists(@RequestHeader("token") String token,
                                    @RequestParam(value = "typeCode", required = false) String typeCode,
                                    @RequestParam(value = "isbn") String isbn,
                                    @RequestParam(value = "serialNumber", required = false) String serialNumber)
            throws BizException, PermissionException;

    @ApiOperation(value = "判断书籍ISBN码是否存在(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "publish", value = "出版社", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "fundName", value = "基金支持", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "书籍号", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "serialNumber", value = "刊物序号", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isCurrentMonth", value = "当月基金支持书刊", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listPage", method = RequestMethod.GET)
    ResponseDto<?> getListPage(@RequestHeader("token") String token,
                               @RequestParam(value = "publish", required = false) String publish,
                               @RequestParam(value = "fundName", required = false) String fundName,
                               @RequestParam(value = "bookName", required = false) String bookName,
                               @RequestParam(value = "isbn", required = false) String isbn,
                               @RequestParam(value = "serialNumber", required = false) String serialNumber,
                               @RequestParam(value = "isCurrentMonth", required = false) Integer isCurrentMonth,
                               @RequestParam(value = "currentPage") Integer currentPage,
                               @RequestParam(value = "numPerPage") Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "判断书籍ISBN码是否存在(平台)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isMainEditor", value = "只看我是主编辑", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "只看基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "templetId", value = "图书类型标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "bookStatus", value = "图书版权保护状态", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "hasQrcode", value = "只看有二维码", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listPage4Adviser", method = RequestMethod.GET)
    ResponseDto<PageBean> getListPage4Adviser(@RequestHeader("token") String token,
                                              @RequestParam(value = "name", required = false) String name,
                                              @RequestParam(value = "bookName", required = false) String bookName,
                                              @RequestParam(value = "isbn", required = false) String isbn,
                                              @RequestParam(value = "channelId", required = false) Long channelId,
                                              @RequestParam(value = "typeCode", required = false) String typeCode,
                                              @RequestParam(value = "currentPage") Integer currentPage,
                                              @RequestParam(value = "numPerPage") Integer numPerPage,
                                              @RequestParam(value = "isMainEditor", required = false) Integer isMainEditor,
                                              @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                              @RequestParam(value = "bookId", required = false) Integer bookId,
                                              @RequestParam(value = "templetId", required = false) Long templetId,
                                              @RequestParam(value = "bookStatus", required = false) Integer bookStatus,
                                              @RequestParam(value = "secondTempletId", required = false) Long secondTempletId,
                                              @RequestParam(value = "hasQrcode",required = false) Integer hasQrcode)
            throws BizException, PermissionException;

    @ApiOperation(value = "首页获取正在做的图书", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "num", value = "个数", dataType = "Integer", paramType = "query")})
    @GetMapping("getList4Adviser")
    ResponseDto<List<BookDto>> getList4Adviser(@RequestHeader("token") String token, @RequestParam(value = "num") Integer num) throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取书籍的详细信息（微信客户端）", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getDetailById", method = RequestMethod.GET)
    ResponseDto<BookDto> getDetailById(@CookieValue("userInfo") String userInfo,
                                       @RequestParam(value = "bookId", required = false) Long bookId,
                                       @RequestParam(value = "adviserId", required = false) Long adviserId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "图书收益，获取书籍基础信息(包含统计信息)（编辑）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getById4Profit", method = RequestMethod.GET)
    ResponseDto<BookDto> getById4Profit(@RequestHeader("token") String token,
                                        @RequestParam(value = "bookId") Long bookId,
                                        @RequestParam(value = "channelId") Long channelId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "判断书籍ISBN码是否存在,存在则获取书籍信息（编辑）", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "isbnExistsOrGetInfo", method = RequestMethod.POST)
    ResponseDto<BookDto> isbnExistsOrGetInfo(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;


    @ApiOperation(value = "创建编辑书籍关联关系（编辑端）", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "setBookAdviserRelation", method = RequestMethod.POST)
    ResponseDto<?> setBookAdviserRelation(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException;

    /**
     * 获取书籍的基本信息(微信客户端)
     */
    @ApiOperation(value = "获取书籍的基本信息(微信客户端)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getBaseInfoById4Wechat", method = RequestMethod.GET)
    ResponseDto<BookDto> getBaseInfoById4Wechat(@CookieValue("userInfo") String userInfo,
                                                @RequestParam(value = "bookId") Long bookId)
            throws BizException, PermissionException;

    /**
     * 获取书籍列表(微信编辑端)
     */
    @ApiOperation(value = "获取书籍列表(微信编辑端)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getListPage4Wechat", method = RequestMethod.GET)
    ResponseDto<PageBean> getListPage4Wechat(@CookieValue("userInfo") String userInfo,
                                             @RequestParam(value = "currentPage") Integer currentPage,
                                             @RequestParam(value = "numPerPage") Integer numPerPage,
                                             @RequestParam(value = "bookName", required = false) String bookName,
                                             @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍列表(XCX)
     */
    @ApiOperation(value = "获取书籍列表(XCX)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getlistPage", method = RequestMethod.GET)
    ResponseDto<PageBean> listPage(@RequestHeader("token") String token,
                                   @RequestParam(value = "currentPage") Integer currentPage,
                                   @RequestParam(value = "numPerPage") Integer numPerPage,
                                   @RequestParam(value = "bookName", required = false) String bookName,
                                   @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 判断书籍ISBN码是否存在,存在则获取书籍信息(微信管理端-编辑)
     */
    @ApiOperation(value = "判断书籍ISBN码是否存在,存在则获取书籍信息(微信管理端-编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "isbnExistsOrGetInfo4Wechat", method = RequestMethod.POST)
    ResponseDto<BookDto> isbnExistsOrGetInfo4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 创建编辑书籍关联关系(微信管理端-编辑)
     */
    @ApiOperation(value = "创建编辑书籍关联关系(微信管理端-编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "setBookAdviserRelation4Wechat", method = RequestMethod.POST)
    ResponseDto<?> setBookAdviserRelation4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端创建书籍(微信管理端-编辑)
     */
    @ApiOperation(value = "微信端创建书籍(微信管理端-编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "create4Wechat", method = RequestMethod.POST)
    ResponseDto<BookDto> create4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 微信端修改书籍(微信管理端-编辑)
     */
    @ApiOperation(value = "微信端修改书籍(微信管理端-编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "update4Wechat", method = RequestMethod.POST)
    ResponseDto<BookDto> update4Wechat(@CookieValue("userInfo") String userInfo, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "根据ISBN获取期刊分页列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "typeCode", value = "书类型编码", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "getJournalPageByIsbn", method = RequestMethod.GET)
    ResponseDto<?> getJournalPageByIsbn(@CookieValue("userInfo") String userInfo,
                                        @RequestParam(value = "typeCode", required = false) String typeCode,
                                        @RequestParam(value = "isbn", required = false) String isbn,
                                        @RequestParam(value = "currentPage") Integer currentPage,
                                        @RequestParam(value = "numPerPage") Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍列表(微信客户端)
     */
    @ApiOperation(value = "获取书籍列表(微信客户端)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listPage4Wechat", method = RequestMethod.GET)
    ResponseDto<PageBean> listPage4Wechat(@CookieValue("userInfo") String userInfo,
                                          @RequestParam(value = "currentPage") Integer currentPage,
                                          @RequestParam(value = "numPerPage") Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍列表(编辑)
     */
    @ApiOperation(value = "获取书籍列表(编辑)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "number", value = "书籍数目", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listBook", method = RequestMethod.GET)
    ResponseDto<List<Object>> listBook(@RequestHeader("token") String token,
                                       @RequestParam(value = "number") Integer number)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍列表(APP-编辑)
     */
    @ApiOperation(value = "获取书籍列表(APP-编辑)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query")})
    @RequestMapping(value = "listBook4App", method = RequestMethod.GET)
    ResponseDto<PageBean> listBook4App(@RequestHeader("token") String token,
                                       @RequestParam(value = "currentPage") Integer currentPage,
                                       @RequestParam(value = "numPerPage") Integer numPerPage,
                                       @RequestParam(value = "bookName", required = false) String bookName)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 书刊列表-出版端
     */
    @ApiOperation(value = "书刊列表-出版端", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookName", value = "书刊名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "mainEditorName", value = "主编辑名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "templetId", value = "图书类型标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "secondTempletId", value = "图书类型二级标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "listPage4Agent", method = RequestMethod.GET)
    ResponseDto<PageBean> listPage4Agent(@RequestHeader("token") String token,
                                         @RequestParam(value = "bookName", required = false) String bookName,
                                         @RequestParam(value = "channelId", required = false) Long channelId,
                                         @RequestParam(value = "typeCode", required = false) String typeCode,
                                         @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                         @RequestParam(value = "numPerPage", required = false) Integer numPerPage,
                                         @RequestParam(value = "mainEditorName", required = false) String mainEditorName,
                                         @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                         @RequestParam(value = "isbn", required = false) String isbn,
                                         @RequestParam(value = "templetId", required = false) Long templetId,
                                         @RequestParam(value = "secondTempletId", required = false) Long secondTempletId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取应用关联的图书
     */
    @ApiOperation(value = "获取应用关联的图书", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "appId", value = "应用标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "listBookByAppId", method = RequestMethod.GET)
    ResponseDto<List<BookDto>> listBookByAppId(@RequestHeader("token") String token,
                                               @RequestParam(value = "appId", required = false) Long appId,
                                               @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍基础信息(包含统计信息)（出版端）
     */
    @ApiOperation(value = "获取书籍基础信息(包含统计信息)（编辑端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getById4Agent", method = RequestMethod.GET)
    ResponseDto<BookDto> getById4Agent(@RequestHeader("token") String token,
                                       @RequestParam(value = "bookId") Long bookId,
                                       @RequestParam(value = "channelId", required = false) Long channelId,
                                       @RequestParam(value = "adviserId", required = false) Long adviserId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取书籍基础信息（平台端）
     */
    @ApiOperation(value = "获取书籍基础信息（平台端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "adviserId", value = "编辑标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getById4Platform", method = RequestMethod.GET)
    ResponseDto<BookDto> getById4Platform(@RequestHeader("token") String token,
            @RequestParam(value = "bookId") Long bookId,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "adviserId", required = false) Long adviserId)
            throws BizException;

    /**
     * 书刊回收站列表（30天内删除的书刊列表）
     */
    @ApiOperation(value = "书刊回收站列表", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")})
    @RequestMapping(value = "listPageDelete4Adviser", method = RequestMethod.GET)
    ResponseDto<PageBean> listPageDelete4Adviser(@RequestHeader("token") String token,
                                                 @RequestParam(value = "currentPage") Integer currentPage,
                                                 @RequestParam(value = "numPerPage") Integer numPerPage)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 获取图书关联超级作者商品个数
     */
    @ApiOperation(value = "获取图书统计个数", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "图书标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "getCount4BookAssoc", method = RequestMethod.GET)
    ResponseDto<BookAssocCount> getCount4BookAssoc(@RequestHeader("token") String token,
                                                   @RequestParam(value = "bookId") Long bookId,
                                                   @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 导出所有书刊成excel表 - 出版端
     */
    @ApiOperation(value = "导出出版下所有书刊excel表（出版端）", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header")})
    @RequestMapping(value = "exportBookToExcel", method = RequestMethod.GET)
    ResponseDto<?> exportBookToExcel(@RequestHeader("token") String token)
            throws PermissionException, JsonParseException, BizException;

    /**
     * 图书列表（平台端）
     */
    @ApiOperation(value = "图书列表（平台端）", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "templetId", value = "书刊分类标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "startDate", value = "开始日期", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "endDate", value = "结束日期", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "bookName", value = "书刊名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "secondTempletId", value = "书刊分类二级列表标识", dataType = "long", paramType = "query")})
    @RequestMapping(value = "listBookClassify", method = RequestMethod.GET)
    ResponseDto<PageBean> listBookClassify(@RequestHeader("token") String token,
                                           @RequestParam(value = "typeCode", required = false) String typeCode,
                                           @RequestParam(value = "templetId", required = false) Long templetId,
                                           @RequestParam(value = "startDate", required = false) String startDate,
                                           @RequestParam(value = "endDate", required = false) String endDate,
                                           @RequestParam(value = "bookName", required = false) String bookName,
                                           @RequestParam(value = "currentPage") Integer currentPage,
                                           @RequestParam(value = "numPerPage") Integer numPerPage,
                                           @RequestParam(value = "secondTempletId", required = false) Long secondTempletId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "导出平台下所有书刊excel表（平台端）", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header")})
    @RequestMapping(value = "exportBookToExcel4Platform", method = RequestMethod.GET)
    ResponseDto<?> exportBookToExcel4Platform(@RequestHeader("token") String token)
            throws PermissionException, JsonParseException, BizException;

    /**
     * 通过isbn获取图书信息(编辑端new)
     */
    @ApiOperation(value = "通过isbn获取图书信息(编辑端new)", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "isbn", value = "书籍号", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "图书类型", dataType = "string", paramType = "query")})
    @RequestMapping(value = "getByIsbnAndTypeCode", method = RequestMethod.GET)
    ResponseDto<BookDto> getByIsbnAndTypeCode(@RequestHeader("token") String token,
                                              @RequestParam(value = "isbn") String isbn,
                                              @RequestParam(value = "typeCode") String typeCode)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 新增书籍(编辑)
     */
    @ApiOperation(value = "新增书籍(编辑)", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "create4Adviser", method = RequestMethod.POST)
    ResponseDto<BookDto> create4Adviser(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    /**
     * 根据ISBN码获取书籍 to exapi
     */
    @ApiOperation(value = "根据ISBN码和serialNumber获取书籍", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "serialNumber", value = "刊物序号", dataType = "string", paramType = "query")})
    @RequestMapping(value = "/getByIsbnAndSerialNumber", method = RequestMethod.GET)
    ResponseDto<BookDto> getByIsbnAndSerialNumber(@RequestParam(value = "isbn", required = true) String isbn,
                                                  @RequestParam(value = "serialNumber", required = false) String serialNumber) throws BizException;


    /**
     * 修改图书类型与图书基本信息
     */
    @ApiOperation(value = "修改图书类型与图书基本信息（编辑）", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "book", value = "书籍实体", dataType = "Book", paramType = "body")})
    @RequestMapping(value = "updateBookAndBookType", method = RequestMethod.POST)
    public ResponseDto<?> updateBookAndBookType(@RequestHeader("token") String token, @RequestBody Book book)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "校验ISBN", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "isbn", value = "ISBN码", dataType = "String", paramType = "query")})
    @RequestMapping(value = "checkISBN4App", method = RequestMethod.GET)
    ResponseDto<Boolean> checkISBN4App(@RequestHeader("token") String token, @RequestParam String isbn) throws PermissionException;


    @ApiOperation(value = "根据渠道ID分页获取图书列表", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "Long", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "name", value = "图书名称、isbn", dataType = "string", paramType = "query")
    })
    @GetMapping("getBookListByChannelId4Adviser")
    ResponseDto<PageBean> getBookListByChannelId4Adviser(
            @RequestHeader("token") String token, @RequestParam(value = "currentPage") Integer currentPage,
            @RequestParam(value = "numPerPage") Integer numPerPage, @RequestParam(value = "channelId") Long channelId,
            @RequestParam(value = "name", required = false) String name) throws PermissionException, JsonParseException, BizException;

    @RequestMapping(value = "listNoAuthBook", method = RequestMethod.POST)
    @ApiOperation(value = "获取未设置正版授权的图书", httpMethod = "POST")
    ResponseDto<PageBeanNew> listNoAuthBook(@RequestHeader("token") String token,
                                                   @RequestBody ListNoAuthBookParam listNoAuthBookParam) throws PermissionException;

    @RequestMapping(value = "listNoAuthGroupBook", method = RequestMethod.POST)
    @ApiOperation(value = "获取未设置正版授权的社群书", httpMethod = "POST")
    ResponseDto<PageBeanNew> listNoAuthGroupBook(@RequestHeader("token") String token,
                                            @RequestBody ListNoAuthGroupBookParam listNoAuthGroupBookParam) throws PermissionException;
}
