package com.pcloud.book.copyright.facade.impl;

import com.pcloud.book.consumer.channel.QrcodeSceneConsr;
import com.pcloud.book.copyright.biz.BookAuthUserBiz;
import com.pcloud.book.copyright.facade.BookAuthUserFacade;
import com.pcloud.book.copyright.vo.BookAuthCodeUserVO;
import com.pcloud.book.copyright.vo.BookClickBuyRecordParam;
import com.pcloud.book.copyright.vo.CheckUserParam;
import com.pcloud.book.copyright.vo.ProvinceTop10VO;
import com.pcloud.book.copyright.vo.SixMonthCountVO;
import com.pcloud.book.copyright.vo.ThirtyDayCountVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author lily
 * @date 2018/12/3 10:59
 */
@RequestMapping("bookAuthUser")
@RestController("bookAuthUserFacade")
public class BookAuthUserFacadeImpl implements BookAuthUserFacade {
    @Autowired
    private BookAuthUserBiz bookAuthUserBiz;

    @Override
    @ApiOperation(value = "获取正版授权总人数", httpMethod = "GET")
    @RequestMapping(value = "getAuthUserCount", method = RequestMethod.GET)
    public ResponseDto<BookAuthCodeUserVO> getAuthUserCount(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId,
                                                            @RequestParam("channelId") Long channelId, @RequestParam(value = "authBookType", required = false) Integer authBookType) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        BookAuthCodeUserVO bookAuthCodeUserVO = bookAuthUserBiz.getAuthUserCount(bookId, channelId, adviserId, authBookType);
        return new ResponseDto<>(bookAuthCodeUserVO);
    }

    @Override
    @RequestMapping(value = "listThirtyDay", method = RequestMethod.GET)
    public ResponseDto<List<ThirtyDayCountVO>> listThirtyDay(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId
            , @RequestParam(value = "province", required = false) String province, @RequestParam(value = "authBookType", required = false) Integer authBookType)
            throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        List<ThirtyDayCountVO> thirtyDayCountVOS = bookAuthUserBiz.listThirtyDay(bookId, channelId, adviserId, province, authBookType);
        return new ResponseDto<>(thirtyDayCountVOS);
    }

    @Override
    @RequestMapping(value = "listSixMonth", method = RequestMethod.GET)
    public ResponseDto<List<SixMonthCountVO>> listSixMonth(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId
            , @RequestParam(value = "province", required = false) String province, @RequestParam(value = "authBookType", required = false) Integer authBookType)
            throws PermissionException, BizException{
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        List<SixMonthCountVO> sixMonthCountVOS = bookAuthUserBiz.listSixMonth(bookId, channelId, adviserId, province, authBookType);
        return new ResponseDto<>(sixMonthCountVOS);
    }

    @Override
    @RequestMapping(value = "listTop10ByBook", method = RequestMethod.GET)
    public ResponseDto<List<ProvinceTop10VO>> listTop10ByBook(@RequestHeader("token") String token, @RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId, @RequestParam(value = "type", required = false) Integer type) throws PermissionException, BizException {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        List<ProvinceTop10VO> provinceTop10VOS = bookAuthUserBiz.listTop10ByBook(bookId, channelId, adviserId, type);
        return new ResponseDto<>(provinceTop10VOS);
    }

    @PostMapping("insertClickBuyRecord")
    public ResponseDto<?> insertClickBuyRecord(@CookieValue("userInfo") String userInfo, @RequestBody BookClickBuyRecordParam bookClickBuyRecordParam)
            throws  BizException{
        Long channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        bookAuthUserBiz.insertClickBuyRecord(bookClickBuyRecordParam, channelId, wechatUserId);
        return new ResponseDto<>();
    }

    @PostMapping("checkIsHaveAuth")
    public ResponseDto<?> checkIsHaveAuth(@CookieValue("userInfo") String userInfo, @RequestBody CheckUserParam checkUserParam)
            throws  BizException{
        Long bookId = checkUserParam.getBookId();
        Long adviserId = checkUserParam.getAdviserId();
        Long channelId = checkUserParam.getChannelId();
        if(null == channelId) {
            channelId = Cookie.getId(userInfo, Cookie._CHANNEL_ID);
        }
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Boolean result = bookAuthUserBiz.checkIsHaveAuth(bookId, channelId, adviserId, wechatUserId, 1);
        return new ResponseDto<>(result);
    }

    @Override
    @GetMapping("checkIsHaveAuthWithServer")
    public ResponseDto<?> checkIsHaveAuthWithServer(@CookieValue("userInfo") String userInfo, @RequestParam("serveId") Long serveId) throws BizException {
        return new ResponseDto<>(bookAuthUserBiz.checkIsHaveAuthWithServer(userInfo,serveId));
    }
}
