package com.pcloud.book.advertising.service.impl;

import com.pcloud.book.advertising.biz.AdvertisingBrandDataBiz;
import com.pcloud.book.advertising.biz.AdvertisingSpaceBiz;
import com.pcloud.book.advertising.biz.GroupTagBiz;
import com.pcloud.book.advertising.biz.LinkRevertBiz;
import com.pcloud.book.advertising.dto.AdvertisingMasterBaseDTO;
import com.pcloud.book.advertising.dto.AdvertisingMasterDTO;
import com.pcloud.book.advertising.dto.BrandDataDTO4Channel;
import com.pcloud.book.advertising.service.AdvertisingSpaceService;
import com.pcloud.book.applet.service.AppletService;
import com.pcloud.book.es.biz.ESBookAndAdviserBiz;
import com.pcloud.book.group.service.BookGroupService;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import io.swagger.annotations.ApiOperation;

/**
 * Description 广告位内部接口实现类
 * Created by PENG on 2019/5/6.
 */
@RestController("advertisingSpaceService")
@RequestMapping("advertisingSpaceService")
public class AdvertisingSpaceServiceImpl implements AdvertisingSpaceService {

    private static final Logger LOGGER = LoggerFactory.getLogger(AdvertisingSpaceServiceImpl.class);

    @Autowired
    private AdvertisingSpaceBiz advertisingSpaceBiz;
    @Autowired
    private GroupTagBiz groupTagBiz;
    @Autowired
    private LinkRevertBiz linkRevertBiz;
    @Autowired
    private BookGroupService bookGroupService;
    @Autowired
    private AdvertisingBrandDataBiz advertisingBrandDataBiz;
    @Autowired
    private ESBookAndAdviserBiz esBookAndAdviserBiz;
    @Autowired
    private AppletService appletService;

    /**
     * 每日凌晨计算昨日广告位收益
     */
    @Override
    @RequestMapping(value = "calculateAdvertisingIncomeYesterday", method = RequestMethod.GET)
    public void calculateAdvertisingIncomeYesterday() throws BizException {
        advertisingSpaceBiz.calculateAdvertisingIncomeYesterday();
        //统计昨日链接发送次数
        linkRevertBiz.addYesterdaySendStatistic();
        //新增读者数量
        bookGroupService.addUserCount4RightsSetting();
        //es书刊数据统计
        esBookAndAdviserBiz.addAllBookAndAdviserToES();
        //小程序
        appletService.checkAnswerUpdate();
    }

    @ApiOperation("发送广告计划")
    @PostMapping("sendAdvertisingPlan")
    @Override
    public void sendAdvertisingPlan(@RequestBody Map<String, Object> map) throws BizException {
        LOGGER.info("内部接口群发广告被调用"+map.toString());
        advertisingSpaceBiz.sendAdvertisingPlan(new Long(map.get("advertisingPutId").toString()));
    }

    @Override
    @GetMapping("getTagWxGroupIdsByUserId")
    @ParamLog("根据登录用户获取标记的微信群列表")
    public ResponseEntity<ResponseDto<List<String>>> getTagWxGroupIdsByUserId(@RequestParam("userId") Long userId) {
        List<String> list = groupTagBiz.getTagWxGroupIdsByUserId(userId);
        return ResponseHandleUtil.toResponse(list);
    }

    @Override
    @GetMapping("getBrandIdsByWxGroupId")
    @ParamLog("查微信群标记的品牌方id")
    public ResponseEntity<ResponseDto<List<Long>>> getBrandIdsByWxGroupId(@RequestParam("wxGroupId") String wxGroupId) {
        List<Long> brandIds = groupTagBiz.getBrandIdsByWxGroupId(wxGroupId);
        return ResponseHandleUtil.toResponse(brandIds);
    }

    @Override
    @PostMapping("mapBrandQrServeAddData")
    public ResponseEntity<ResponseDto<Map<Long, BrandDataDTO4Channel>>> mapBrandQrServeAddData(@RequestBody BrandDataDTO4Channel brandDataDTO4Channel) {
        return ResponseHandleUtil.toResponse(advertisingBrandDataBiz.mapBrandQrServeAddData(brandDataDTO4Channel));
    }

    @Override
    @PostMapping("mapBrandQrAddData")
    public ResponseEntity<ResponseDto<Map<Long, BrandDataDTO4Channel>>> mapBrandQrAddData(@RequestBody BrandDataDTO4Channel brandDataDTO4Channel) {
        return ResponseHandleUtil.toResponse(advertisingBrandDataBiz.mapBrandQrAddData(brandDataDTO4Channel));
    }

    @Override
    public ResponseEntity<ResponseDto<List<AdvertisingMasterBaseDTO>>> getAllMasterBaseInfo() throws BizException {
        List<AdvertisingMasterDTO> allMaster = advertisingSpaceBiz.getAllMaster();
        ArrayList<AdvertisingMasterBaseDTO> dtoList = new ArrayList<>();
        if(allMaster!=null){
            allMaster.stream().forEach((e)->{
                AdvertisingMasterBaseDTO baseDto = new AdvertisingMasterBaseDTO();
                baseDto.setId(e.getId());
                baseDto.setMasterName(e.getMasterName());
                baseDto.setCreateTime(e.getCreateTime());
                baseDto.setUpdateTime(e.getUpdateTime());
                dtoList.add(baseDto);
            });
        }
        return ResponseHandleUtil.toResponse(dtoList);
    }

}
