package com.pcloud.book.applet.dao;

import com.pcloud.book.applet.dto.AppletUserBookcaseDTO;
import com.pcloud.book.applet.dto.BaseTempletClassifyDTO;
import com.pcloud.book.applet.dto.UserLastBookReDTO;
import com.pcloud.book.applet.entity.AppletUserBookcase;
import com.pcloud.book.applet.entity.AppletUserClickRecord;
import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 小程序用户书架
 */
public interface AppletUserBookcaseDao extends BaseDao<AppletUserBookcase> {

    /**
     * 新增用户资源点击记录
     * @param appletUserClickRecord
     */
    void  insertClickRecord(AppletUserClickRecord appletUserClickRecord);

    /**
     * 用户点击的服务id
     * @param wechatUserId
     * @param bookId
     * @param channelId
     * @param adviserId
     * @return
     */
    Integer getUserClickServerCount(Long wechatUserId, Long bookId, Long channelId, Long adviserId, List<Long> serveIds, String fromType);

    /**
     * 最早资源点击日期
     * @param wechatUserId
     * @param bookId
     * @param channelId
     * @param adviserId
     * @return
     */
    String getMinClickTime (Long wechatUserId, Long bookId, Long channelId, Long adviserId, List<Long> serveIds, String fromType);

    /**
     * 删除
     * @param appletUserBookcase
     */
    void deleteByBookIdUserId(AppletUserBookcase appletUserBookcase);

    UserLastBookReDTO getUserLastGroupBookRe(Long wechatUserId);

    /**
     * 用户最后点击的小睿书或者馆配书
     * @author：zhuyajie
     * @date：2021/6/3 9:32
     *  * @param null
     */
    UserLastBookReDTO getUserLastRe(List<Long> wechatUserIdList, Long adviserId, Long bookId);

    /**
     * 批量删除
     * @author：zhuyajie
     * @date：2020/5/11 16:06
     *  * @param null
     */
    void deleteByIds(List<Long> ids);

    void updateUserReadType(AppletUserBookcase appletUserBookcase);

    AppletUserBookcase getUserReadType(List<Long> wechatUserIdList, Long bookId, Long adviserId, Long channelId);
    /**
     * 查书架列表
     * @author：zhuyajie
     * @date：2020/5/15
     *  * @param null
     */
    List<AppletUserBookcase> getListByUserId(Long wechatUserId);

    /**
     * 书架id
     * @author：zhuyajie
     * @date：2020/5/29 13:11
     *  * @param null
     */
    List<Long> getBookcaseIdListByUser(List<Long> wechatUserIdList);
    /**
     * 更新书刊对应的权益
     * @author：zhuyajie
     * @date：2020/6/12 17:25
     *  * @param null
     */
    void updateRightsSettingId(Long rightsSettingId, Long bookId, Long adviserId, Long channelId);
    /**
     * 书刊访问用户数量
     * @author：zhuyajie
     * @date：2020/6/15 11:40
     *  * @param null
     */
    List<AppletUserBookcaseDTO> getBookUserCountList(List<Long> bookIds);
    /**
     * 根据id获取书刊id
     * @author：zhuyajie
     * @date：2020/6/15 12:40
     *  * @param null
     */
    List<Long> getBookIdsByIds(List<Long> ids);

    AppletUserBookcaseDTO getUserBookInfoByWechatUserId(Long bookId, Long channelId, Long adviserId);

    AppletUserBookcase getUserReadBook(Long wechatUserId);

    BaseTempletClassify getBookClassifyInfo(Long bookId, Long channelId, Long adviserId);

    BaseTempletClassify getLastReadBookInfo(Long wechatUserId);

    UserLastBookReDTO getUserLastGroupBook(Long wechatUserId);

    BaseTempletClassifyDTO getLastReadBookInfoByUsers(List<Long> wechatUserIds);

    List<Long> getSameClassifyUserIds(BaseTempletClassifyDTO baseTempletClassifyDTO);
}
