/**
 *
 */
package com.pcloud.book.book.dao.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.google.common.collect.Maps;
import com.pcloud.book.book.dao.BookAdviserDao;
import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.dto.AdviserManageDto;
import com.pcloud.book.book.dto.AviserBookInfoParam;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.book.book.dto.BookCountAndAdviserIdDTO;
import com.pcloud.book.book.dto.BookCountByAdvisersDto;
import com.pcloud.book.book.dto.BookCountDto;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.book.dto.ERPPublishNumDTO;
import com.pcloud.book.book.dto.ErpBookInfoDTO;
import com.pcloud.book.book.entity.BookAdviser;
import com.pcloud.book.book.vo.AgentBookStatsDetailVO;
import com.pcloud.book.book.vo.BookInfo4ScanCount;
import com.pcloud.book.book.vo.BookServesListDTO;
import com.pcloud.book.book.vo.ErpAdviserBookVO;
import com.pcloud.book.book.vo.request.RelateRaysBookApprovalVO;
import com.pcloud.book.es.entity.ESBookAndAdviser;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.apache.ibatis.session.ResultHandler;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @描述：编辑管理书籍数据访问层接口实现类
 * @作者：songx
 * @创建时间：2016年12月30日,下午5:15:37 @版本：1.0
 */
@Repository("bookAdviserDao")
public class BookAdviserDaoImpl extends BaseDaoImpl<BookAdviser> implements BookAdviserDao {

	@Override
	public List<Long> listBookIdsByAdviser(Long adviserId) {
		return this.getSqlSession().selectList(this.getStatement("listBookIdsByAdviser"), adviserId);
	}

	/**
	 * 删除编辑和书籍的推广信息
	 */
	@Override
	public long deleteByBook(Long bookId) {
		return super.getSqlSession().update(super.getStatement("deleteByBook"), bookId);
	}

	/**
	 * 批量删除编辑和书籍的推广信息
	 */
	@Override
	public long deleteByBooks(List<Long> bookIds) {
		return super.getSqlSession().delete(super.getStatement("deleteByBooks"), bookIds);
	}

	/**
	 * 获取编辑设置的书籍推广信息
	 */
	@Override
	public BookAdviserDto getByAdviser(BookAdviser bookAdviser) {
		return super.getSqlSession().selectOne(super.getStatement("getByAdviser"), bookAdviser);
	}

	/**
	 * 统计编辑推广的图书总数
	 */
	@Override
	public Map<Long, BookAdviserDto> getCountByAdvisers(List<Long> adviserIds) {
		return super.getSqlSession().selectMap(super.getStatement("getCountByAdvisers"), adviserIds, "adviserId");
	}

	/**
	 * 根据ISBN获取图书信息
	 */
	@Override
	public BookAdviserDto getByIsbn(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(super.getStatement("getByIsbn"), paramMap);
	}

	/**
	 * 获取配置过书籍的编辑top1
	 */
	@Override
	public Long getAdviserTop1(Map<String, Object> paramMap) {
		return super.getSqlSession().selectOne(super.getStatement("getAdviserTop1"), paramMap);

	}

	/**
	 * 根据书籍和渠道删除书籍编辑关联信息
	 */
	@Override
	public Integer deleteByBookAndChannel(Map<String, Object> paramMap) {

		return super.getSqlSession().update(super.getStatement("deleteByBookAndChannel"), paramMap);

	}

	/**
	 * 根据图书信息获取主编辑ID
	 */
	@Override
	public Long getMainAdviserId(Long bookId, Long channelId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId", bookId);
		paramMap.put("channelId", channelId);
		return super.getSqlSession().selectOne(super.getStatement("getMainAdviserId"), paramMap);
	}

	/**
	 * 根据bookId获取编辑信息
	 */
	@Override
	public List<AdviserManageDto> getAdviserList(Long bookId) {

		return super.getSqlSession().selectList(this.getStatement("getAdviserList"), bookId);
	}

	/**
	 * 根据bookId获取编辑ID
	 */
	@Override
	public List<Long> getAdviserIdsByBookId(Long bookId) {

		return super.getSqlSession().selectList(this.getStatement("getAdviserIdsByBookId"), bookId);
	}

	/**
	 * 编辑管理--删除副编辑
	 */
	@Override
	public Integer delViceAdviser(List<BookAdviser> bookAdvisers) {

		return super.getSqlSession().delete(super.getStatement("delViceAdviser"), bookAdvisers);
	}

	/**
	 * 获取在某个运营平台关联过某本书的所有编辑的ID（未删除的）
	 */
	@Override
	public List<Long> getAdviserIdsByBookAndChannel(Long bookId, Long channelId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId", bookId);
		paramMap.put("channelId", channelId);
		return super.getSqlSession().selectList(this.getStatement("getAdviserIdsByBookAndChannel"), paramMap);
	}

	/**
	 * 根据bookIds查询书刊编辑关联信息
	 */
	@Override
	public Map<Long, BookAdviserDto> getByBookIds(List<Long> bookIds) {
		return super.getSqlSession().selectMap(this.getStatement("getByBookIds"), bookIds, "bookId");
	}

	/**
	 * 编辑下的所有书刊的数目
	 */
	@Override
	public Integer getBookCount(List<Long> adviserIds) {
		return super.getSqlSession().selectOne(this.getStatement("getBookCount"), adviserIds);
	}

	/**
	 * 更新图书模板信息
	 */
	@Override
	public void updateBookTemplet(BookAdviser bookAdviser) {
		super.getSqlSession().update(this.getStatement("updateBookTemplet"), bookAdviser);
	}

	/**
	 * 每日新增书刊数-出版
	 */
	@Override
	public List<BookCountDto> listBookCountByDate4Agent(Map<String, Object> paramMap) {
		return super.getSqlSession().selectList(this.getStatement("listBookCountByDate4Agent"), paramMap);
	}

	/**
	 * 删除书籍（编辑端）
	 */
	@Override
	public void updateBook4Adviser(Map<String, Object> paramMap) {
		super.getSqlSession().update(this.getStatement("updateBook4Adviser"), paramMap);
	}

	/**
	 * 该书是否是主编辑
	 */
	@Override
	public Boolean isMainAdviser4Book(Map<String, Long> paramMap) {
		return super.getSqlSession().selectOne(this.getStatement("isMainAdviser4Book"), paramMap);
	}

	/**
	 * 获取编辑设置的书籍推广信息(包含删除或未删除的)
	 */
	@Override
	public BookAdviserDto getByAdviserContainsDelete(BookAdviser bookAdviser) {
		return super.getSqlSession().selectOne(super.getStatement("getByAdviserContainsDelete"), bookAdviser);
	}

	/**
	 * 获取编辑的图书总数
	 */
	@Override
	public Integer getAdviserBookCount(Long adviserId) {
		return super.getSqlSession().selectOne(super.getStatement("getAdviserBookCount"), adviserId);
	}

	/**
	 * 获取被诉方信息(即与该书关联的所有编辑)
	 */
	@Override
	public List<BookAdviserDto> getAdvisers(Long bookId) {
		return super.getSqlSession().selectList(super.getStatement("getAdvisers"), bookId);
	}

	/**
	 * 获取该书被多少主编辑推广过
	 * @param bookId 图书标识
	 * @return
	 */
	@Override
	public Integer getCount4BookAdviser(Long bookId) {
		return super.getSqlSession().selectOne(this.getStatement("getCount4BookAdviser"), bookId);
	}

	@Override
	public BookAdviserDto getBase(Long bookId, Long channelId, Long adviserId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("channelId", channelId);
		paramMap.put("adviserId", adviserId);
		return super.getSqlSession().selectOne(this.getStatement("getBase"), paramMap);
	}
    @Override
    public List<AdviserBookInfoDTO> listAdviserBookInfo(AviserBookInfoParam aviserBookInfoParam) {
		return super.getSqlSession().selectList(this.getStatement("listAdviserBookInfo"), aviserBookInfoParam);
    }

	@Override
	public Map<Long, BookCountAndAdviserIdDTO> getBookCountByAdviserId(BookCountByAdvisersDto bookCountByAdvisersDto) {
		return super.getSqlSession().selectMap(this.getStatement("getBookCountByAdviserId"),bookCountByAdvisersDto,"adviserId");
	}

	@Override
	public int updateBookBySecondTempletId(Long parentId,Long originTempletId, Long secondTempletId) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("parentId",parentId);
		map.put("originTempletId",originTempletId);
		map.put("secondTempletId",secondTempletId);
		return getSqlSession().update(getStatement("updateBookBySecondTempletId"),map);
	}

	@Override
	public List<ErpAdviserBookVO> listAdviserBook4Erp(Map<String, Object> map) {
		return getSqlSession().selectList(getStatement("listAdviserBook4Erp"),map);
	}

	/**
     * 设置书刊是否已下印状态
     */
	@Override
	public long setIsPrint(BookAdviser bookAdviser) {
	    return super.getSqlSession().update(getStatement("setIsPrint"), bookAdviser);
    }

	@Override
	public List<Long> getBookIdsByTempletId(Long templetId) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("templetId",templetId);
		return getSqlSession().selectList(getStatement("getBookIdsByTempletId"),map);
	}

	@Override
	public BookAdviserDto getOneMainBook(Long bookId) {
		return getSessionTemplate().selectOne(getStatement("getOneMainBook"),bookId);
	}

	@Override
	public Map<Long, BookAdviserDto> getByBookAdviserIds(List<Long> bookAdviserIds) {
		return super.getSqlSession().selectMap(this.getStatement("getByBookAdviserIds"), bookAdviserIds, "bookAdviserId");

	}

    @Override
    public BookAdviserDto getByBookGroupId(Long bookGroupId) {
		return getSessionTemplate().selectOne(getStatement("getByBookGroupId"),bookGroupId);
    }

	@Override
	public Integer getBookCountByTime(List<Long> adviserIds, String startTime, String endTime) {
		Map<String, Object> map = new HashMap<>();
		map.put("adviserIds", adviserIds);
		map.put("startTime", startTime);
		map.put("endTime", endTime);
		return getSessionTemplate().selectOne(getStatement("getBookCountByTime"), map);
	}
	@Override
	public Long getRayBookCount(String startTime, String endTime) {
		Map<String,Object> map = Maps.newHashMap();
		map.put("startTime", startTime);
		map.put("endTime", endTime);
		return getSessionTemplate().selectOne(getStatement("getRayBookCount"), map);
	}

	@Override
	public Integer getIsRui(Long adviserId, Long bookId, Long channelId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("channelId", channelId);
		paramMap.put("adviserId", adviserId);
		return super.getSqlSession().selectOne(this.getStatement("getIsRui"), paramMap);
	}

	@Override
	public List<BookAdviserDto> getBookInfoByBookIds(List<Long> bookIds, List<Long> adviserIds, List<Long> channelIds) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookIds", bookIds);
		paramMap.put("adviserIds", adviserIds);
		paramMap.put("channelIds", channelIds);
		return super.getSqlSession().selectList(this.getStatement("getBookInfoByBookIds"), paramMap);
	}

	@Override
	public BookAdviserDto getBookByBookIdAdviserId(Long bookId, Long adviserId){
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("adviserId", adviserId);
		return super.getSqlSession().selectOne(this.getStatement("getBookByBookIdAdviserId"), paramMap);
	}
	@Override
	public List<BookAdviserDto> getAdviserBookVarietyStats(List<Long> adviserIds) {
		return super.getSqlSession().selectList(this.getStatement("getAdviserBookVarietyStats"), MapUtil.of("adviserIds",adviserIds));
	}

    @Override
    public List<ERPPublishNumDTO> getErpPublishNumQueryParams(List<Long> adviserIds) {
        return super.getSqlSession().selectList(getStatement("getErpPublishNumQueryParams"),MapUtil.of("adviserIds",adviserIds));
    }

	@Override
	public List<ERPPublishNumDTO> getErpPublishNumQueryParamsByMonth(List<Long> adviserIds,int month) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("adviserIds",adviserIds);
		paramMap.put("month", month);
		return super.getSqlSession().selectList(getStatement("getErpPublishNumQueryParamsByMonth"),paramMap);
	}

	@Override
	public Map<Long, BookDto> getBookMapByAdviserBookIds(List<Long> adviserBookIds) {
		return getSessionTemplate().selectMap(getStatement("getBookMapByAdviserBookIds"), adviserBookIds, "bookAdviserId");
	}


	@Override
	public List<AgentBookStatsDetailVO> getAgentBookStatsDetail(List<ErpBookInfoDTO> raysBookIds, Integer isRay, String name, List<Long> advisers) {
		Map<String, Object> map = new HashMap<>();
		if (StrUtil.isNotBlank(name) && name.startsWith("BK")){
			map.put("bookNo", name.substring(2));
		}
		map.put("raysBookIds", CollUtil.isEmpty(raysBookIds) ? null : raysBookIds);
		map.put("isRay", isRay);
		map.put("name", name);
		map.put("advisers", advisers);
		return super.getSqlSession().selectList(getStatement("getAgentBookStatsDetail"), map);
	}

	@Override
	public void updateBookTempletAndLabel(BookAdviser bookAdviser) {
		super.getSqlSession().update(this.getStatement("updateBookTempletAndLabel"), bookAdviser);
	}

	@Override
	public void syncTempletId4ES(ResultHandler<ESBookAndAdviser> resultHandler) {
		super.getSqlSession().select(getStatement("syncTempletId4ES"), resultHandler);
	}

	@Override
	public List<BookInfo4ScanCount> listBookInfo4ScanCount(List<Long> adviserIds, List<Long> channelIds, List<Long> bookIds) {
		HashMap<String, List<Long>> param = MapUtil.of("adviserIds", adviserIds);
		param.put("channelIds",channelIds);
		param.put("bookIds",bookIds);
		return getSessionTemplate().selectList(getStatement("listBookInfo4ScanCount"), param);
	}

	@Override
	public void updateSendMiniUrlState(Long bookId, Long adviserId, Long channelId, Integer isSendMiniUrl) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("channelId", channelId);
		paramMap.put("adviserId", adviserId);
		paramMap.put("isSendMiniUrl", isSendMiniUrl);
		getSessionTemplate().update(getStatement("updateSendMiniUrlState"), paramMap);
	}

	@Override
	public BookDto getBookByBookIdAdviserIdChannelId(Long bookId, Long channelId, Long adviserId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("channelId", channelId);
		paramMap.put("adviserId", adviserId);
		return getSessionTemplate().selectOne(getStatement("getBookByBookIdAdviserIdChannelId"), paramMap);
	}

	@Override
	public BookDto getLatestAdviserBookByIsbn(String isbn) {
		return getSessionTemplate().selectOne(getStatement("getLatestAdviserBookByIsbn"), isbn);
	}

	@Override
	public List<BookServesListDTO> listBookServes4Book(Long cursor, Integer limit) {
		HashMap<String, Object> params = MapUtil.of("cursor", cursor);
		params.put("limit", limit);
		return getSessionTemplate().selectList(getStatement("listBookServes4Book"), params);
	}

	@Override
	public void updateOpenCatalogState(Long bookId, Long adviserId, Long channelId, Integer isOpenCatalog) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("channelId", channelId);
		paramMap.put("adviserId", adviserId);
		paramMap.put("isOpenCatalog", isOpenCatalog);
		getSessionTemplate().update(getStatement("updateOpenCatalogState"), paramMap);
	}

	@Override
	public int updateRaysField4Erp(List<RelateRaysBookApprovalVO> approvalList) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("approvalList", approvalList);
		return getSessionTemplate().update(getStatement("updateRaysField4Erp"), paramMap);
	}

	@Override
	public Integer hasApprovalBook4Adviser(Long adviserId) {
		return getSessionTemplate().selectOne(getStatement("hasApprovalBook4Adviser"), adviserId);
	}

	@Override
	public void updateBookPhoneAuth(Long bookId, Long adviserId, Long channelId, Integer bookPhoneAuth) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("channelId", channelId);
		paramMap.put("adviserId", adviserId);
		paramMap.put("bookPhoneAuth", bookPhoneAuth);
		getSessionTemplate().update(getStatement("updateBookPhoneAuth"), paramMap);
	}

	@Override
	public Integer getBookPhoneAuth(Long bookId, Long adviserId, Long channelId) {
		Map<String, Object> paramMap = new HashMap<>();
		paramMap.put("bookId",bookId);
		paramMap.put("channelId", channelId);
		paramMap.put("adviserId", adviserId);
		return  getSessionTemplate().selectOne(getStatement("getBookPhoneAuth"), paramMap);
	}
}
