package com.pcloud.book.copyright.biz.impl;

import com.pcloud.book.copyright.biz.BookExportRecordBiz;
import com.pcloud.book.copyright.dao.BookExportRecordDao;
import com.pcloud.book.copyright.dto.BookExportRecordDTO;
import com.pcloud.book.copyright.entity.BookExportRecord;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/4 19:14
 */
@Component("bookExportRecordBiz")
public class BookExportRecordBizImpl implements BookExportRecordBiz {

    @Autowired
    private BookExportRecordDao bookExportRecordDao;


    @Override
    public void insertRecord(BookExportRecord bookExportRecord) {
        bookExportRecordDao.insert(bookExportRecord);
    }

    @Override
    public void updateRecordStatus(BookExportRecord bookExportRecord) {
        bookExportRecordDao.updateRecordStatus(bookExportRecord);
    }

    @Override
    public Boolean isHaveExport(Long bookId, Long channelId, Long adviserId) {
        return  bookExportRecordDao.isHaveExport(bookId, channelId, adviserId);
    }

    @Override
    public void updateRecord(BookExportRecord bookExportRecord) {
        bookExportRecordDao.updateRecord(bookExportRecord);
    }

    @Override
    public void handleExportFail() {
        bookExportRecordDao.handleExportFail();
    }

    @Override
    public PageBeanNew<BookExportRecordDTO> getGenerateCodeHistory(Long bookId, Long adviserId, Long channelId, PageParam pageParam) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookId",bookId);
        paramMap.put("channelId",channelId);
        paramMap.put("adviserId",adviserId);

        PageBeanNew<BookExportRecordDTO> pageBeanNew = bookExportRecordDao.listPageNew(pageParam, paramMap, "getGenerateCodeHistory");
        if(pageBeanNew == null || CollectionUtils.isEmpty(pageBeanNew.getRecordList())){
            return pageBeanNew;
        }
        //填充导出格式
        pageBeanNew.getRecordList().forEach(e->{
            e.setImportType(getImportType(e.getIsHaveBarCode()));
        });
        return pageBeanNew;
    }

    private String getImportType(Integer type){
        if(null==type){
            return "";
        }
        switch (type){
            case 0:
                return "正版授权码+条形码";
            case 1:
                return "正版授权码";
            case 2:
                return "二维码";
                default: return "";
        }
    }
}
