package com.pcloud.book.copyright.dao.impl;

import com.pcloud.book.base.enums.BookStatusEnum;
import com.pcloud.book.copyright.dao.BookAuthInfoDao;
import com.pcloud.book.copyright.dto.BookAuthInfoCountDTO;
import com.pcloud.book.copyright.entity.BookAuthInfo;
import com.pcloud.book.copyright.vo.BookAuthInfoVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2018/12/3 15:19
 */
@Component("bookAuthInfoDao")
public class BookAuthInfoDaoImpl extends BaseDaoImpl<BookAuthInfo> implements BookAuthInfoDao {

    @Override
    public BookAuthInfo getById(Long id) {
        return this.getSqlSession().selectOne(this.getStatement("getById"), id);
    }

    @Override
    public Boolean getIsHaveAuthBook(Long adviserId) {
        return this.getSqlSession().selectOne(this.getStatement("getIsHaveAuthBook"), adviserId);
    }

    @Override
    public void updateLocationDesc(BookAuthInfo bookAuthInfo) {
        this.getSqlSession().update(this.getStatement("updateLocationDesc"), bookAuthInfo);
    }

    @Override
    public BookAuthInfoVO getInfoByBook(Long bookId, Long channelId, Long adviserId, Integer authBookType) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        if(authBookType == null || authBookType.equals(0)) {
            paramMap.put("isPaperBook", 1);
            paramMap.put("isGroupBook", 0);
        } else {
            paramMap.put("isPaperBook", 0);
            paramMap.put("isGroupBook", 1);
        }
        return this.getSqlSession().selectOne(this.getStatement("getInfoByBook"), paramMap);
    }

    @Override
    public void updateBookStatus(Long id, Integer bookStatus, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("id", id);
        paramMap.put("bookStatus", bookStatus);
        paramMap.put("adviserId", adviserId);
        if(BookStatusEnum.PROTECT.value.equals(bookStatus)){
            paramMap.put("openTime", new Date());
        }else{
            paramMap.put("closeTime", new Date());
        }
        this.getSqlSession().update(this.getStatement("updateBookStatus"), paramMap);
    }

    @Override
    public void updateBaseInfo(BookAuthInfo bookAuthInfo) {
        this.getSqlSession().update(this.getStatement("updateBaseInfo"), bookAuthInfo);
    }

    @Override
    public BookAuthInfoCountDTO getBookAuthCount(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bookId", bookId);
        paramMap.put("channelId", channelId);
        paramMap.put("adviserId", adviserId);
        return this.getSqlSession().selectOne(this.getStatement("getBookAuthCount"),paramMap);
    }

    @Override
    public Integer getTotalNum(List<Long> adviserIds, List<Long> removeAdviserIds) {
        Map<String , Object> paramMap = new HashMap<>();
        paramMap.put("adviserIds",adviserIds);
        paramMap.put("removeAdviserIds",removeAdviserIds);
        return this.getSqlSession().selectOne(this.getStatement("getTotalNum"), paramMap);
    }
}
