package com.pcloud.book.cultivate.dao.impl;

import com.pcloud.book.cultivate.dao.CultivateNotifySendDao;
import com.pcloud.book.cultivate.dto.CultivateNotifyDTO;
import com.pcloud.book.cultivate.dto.CultivateNotifyTypeDTO;
import com.pcloud.book.cultivate.entity.CultivateNotifySend;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("cultivateNotifySendDao")
public class CultivateNotifySendDaoImpl extends BaseDaoImpl<CultivateNotifySend> implements CultivateNotifySendDao {

    @Override
    public Long getFirstNoReadNotify(Long wechatUserId) {
        return super.getSessionTemplate().selectOne(getStatement("getFirstNoReadNotify"),wechatUserId);
    }

    @Override
    public void updateIsRead(Long wechatUserId, Long messageId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("messageId",messageId);
        super.getSessionTemplate().update(getStatement("updateIsRead"),map);
    }

    @Override
    public void updateShowHome(Long wechatUserId) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        super.getSessionTemplate().update(getStatement("updateShowHome"),map);
    }

    @Override
    public List<CultivateNotifyTypeDTO> getNotify4Type(Long wechatUserId) {
        return super.getSessionTemplate().selectList(getStatement("getNotify4Type"),wechatUserId);
    }

    @Override
    public List<CultivateNotifyDTO> getNotifyListByType(Long wechatUserId, Integer messageType,Integer currentPage,Integer numPerPage) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("messageType",messageType);
        return super.getSessionTemplate().selectList(getStatement("getNotifyListByType"),map);

    }

    @Override
    public List<CultivateNotifySend> getNotifySendsByType(Long wechatUserId, Integer messageType) {
        Map<String,Object> map=new HashMap<>();
        map.put("wechatUserId",wechatUserId);
        map.put("messageType",messageType);
        return super.getSessionTemplate().selectList(getStatement("getNotifySendsByType"),map);
    }

    @Override
    public List<Long> getSendUserIds(Long messageId, Integer currentPage, Integer numPerPage) {
        Map<String,Object> map=new HashMap<>();
        map.put("messageId",messageId);
        map.put("pageNum",currentPage*numPerPage);
        map.put("numPerPage",numPerPage);
        return super.getSessionTemplate().selectList(getStatement("getSendUserIds"),map);
    }

    @Override
    public Integer getSendUserCount(Long messageId) {
        Map<String,Object> map=new HashMap<>();
        map.put("messageId",messageId);
        return super.getSessionTemplate().selectOne(getStatement("getSendUserCount"),map);
    }

    @Override
    public void clearExpireNotifies() {
        getSessionTemplate().delete(getStatement("clearExpireNotifies"));
    }
}
