package com.pcloud.book.group.dao.impl;

import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.group.dao.BookGroupCipherUserDao;
import com.pcloud.book.group.dto.AltAndCountDTO;
import com.pcloud.book.group.dto.BookGroupIdAndCountDTO;
import com.pcloud.book.group.dto.CountAndTimeDTO;
import com.pcloud.book.group.dto.DayCountDTO;
import com.pcloud.book.group.dto.LabelUserCountDTO;
import com.pcloud.book.group.dto.SelfRobotBookGroupDTO;
import com.pcloud.book.group.dto.SelfRobotUserDTO;
import com.pcloud.book.group.entity.BookGroupCipherUser;
import com.pcloud.book.group.vo.UserBookInfoItemVO;
import com.pcloud.book.group.vo.UserBookInfoVO;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/24 15:19
 **/
@Component("bookGroupCipherUserDao")
public class BookGroupCipherUserDaoImpl extends BaseDaoImpl<BookGroupCipherUser> implements BookGroupCipherUserDao {
    @Override
    public Long getBookGroupIdByWxUserId(String wxUserId) {
        return this.getSqlSession().selectOne(this.getStatement("getBookGroupIdByWxUserId"), wxUserId);
    }

    @Override
    public Integer getFriendsCountByBookGroup(Long bookGroupId) {
        return getSessionTemplate().selectOne(getStatement("getFriendsCountByBookGroup"), bookGroupId);
    }


    @Override
    public List<DayCountDTO> getBookGroupFriendsCountByDay(Long bookGroupId, String startTime, String endTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return getSessionTemplate().selectList(getStatement("getBookGroupFriendsCountByDay"), map);
    }

    @Override
    public Integer getFriendsCountByBookGroupByTime(Long bookGroupId, String startTime, String endTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return getSessionTemplate().selectOne(getStatement("getFriendsCountByBookGroupByTime"), map);
    }

    @Override
    public List<BookGroupCipherUser> getWxUserIdAndAltsByBookGroupId(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return getSessionTemplate().selectList(getStatement("getWxUserIdAndAltsByBookGroupId"), map);
    }

    @Override
    public List<String> getFriendIdsByBookGroupId(Long bookGroupId) {
        return getSessionTemplate().selectList(getStatement("getFriendIdsByBookGroupId"), bookGroupId);
    }

    @Override
    public List<BookDto> getBookGroupListByUser(String wxUserId, String altId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxUserId", wxUserId);
        map.put("altId", altId);
        return getSessionTemplate().selectList(getStatement("getBookGroupListByUser"), map);
    }

    @Override
    public Integer getAddFriendCount() {
        return getSessionTemplate().selectOne(getStatement("getAddFriendCount"));
    }

    @Override
    public List<CountAndTimeDTO> getAddFriendCountByTime(Integer timeType, String startTime, String endTime) {
        Map<String, Object> map = new HashMap<>();
        map.put("timeType", timeType);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return getSessionTemplate().selectList(getStatement("getAddFriendCountByTime"), map);
    }

    @Override
    public List<SelfRobotUserDTO> listPageFriendInfo(Map<String, Object> paramMap) {
        return getSessionTemplate().selectList(getStatement("listPageFriendInfo"), paramMap);
    }

    @Override
    public List<LabelUserCountDTO> getUserLabelDistribution(Integer type, List<String> altIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("type", type);
        map.put("altIds", altIds);
        return getSessionTemplate().selectList(getStatement("getUserLabelDistribution"), map);
    }

    @Override
    public List<BookGroupCipherUser> getAltIdByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds", bookGroupIds);
        return getSessionTemplate().selectList(getStatement("getAltIdByBookGroupIds"), map);
    }

    @Override
    public List<BookGroupIdAndCountDTO> getAddFriendByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds", bookGroupIds);
        return getSessionTemplate().selectList(getStatement("getAddFriendByBookGroupIds"), map);
    }

    @Override
    public List<BookGroupCipherUser> getWxUserIdAndAltsByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds", bookGroupIds);
        return getSessionTemplate().selectList(getStatement("getWxUserIdAndAltsByBookGroupIds"), map);
    }

    @Override
    public List<AltAndCountDTO> getBookGroupCountListByAltIds(List<String> altIds) {
        return getSessionTemplate().selectList(getStatement("getBookGroupCountListByAltIds"), altIds);
    }

    @Override
    public List<Long> getBookGroupIdsByAltIds(List<String> altIds) {
        return getSessionTemplate().selectList(getStatement("getBookGroupIdsByAltIds"), altIds);
    }

    @Override
    public List<String> getAltIdsByAgentId(Long agentId) {
        return getSessionTemplate().selectList(getStatement("getAltIdsByAgentId"), agentId);
    }

    @Override
    public List<UserBookInfoItemVO> getScanBookInfoByUser(String wxUserId, String altId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxUserId", wxUserId);
        map.put("altId", altId);
        return getSessionTemplate().selectList(getStatement("getScanBookInfoByUser"), map);
    }

    @Override
    public List<UserBookInfoVO> listUser4SelfPush(Map<String, Object> map) {
        return getSessionTemplate().selectList(getStatement("listUser4SelfPush"), map);
    }

    @Override
    public List<UserBookInfoVO> listUser4SelfPushByAdvise(Map<String, Object> map) {
        return getSessionTemplate().selectList(getStatement("listUser4SelfPushByBookGroupId"),map);
    }

    @Override
    public List<String> getFriendIdListByBookAndRobot(String altId, List<Long> bookIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookIds", bookIds);
        map.put("altId", altId);
        return getSessionTemplate().selectList(getStatement("getFriendIdListByBookAndRobot"), map);
    }

    @Override
    public Long getLatestCipherBookGroup(String altId, String wxUserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxUserId", wxUserId);
        map.put("altId", altId);
        return getSessionTemplate().selectOne(getStatement("getLatestCipherBookGroup"), map);
    }

    @Override
    public Integer getAltCountByBookGroup(Long bookGroupId) {
        return getSessionTemplate().selectOne(getStatement("getAltCountByBookGroup"), bookGroupId);
    }

    @Override
    public List<AltAndCountDTO> getAltFriendList(Long bookGroupId) {
        return getSessionTemplate().selectList(getStatement("getAltFriendList"), bookGroupId);
    }

    @Override
    public BookGroupCipherUser getByWxUserId(String wxUserId) {
        return getSessionTemplate().selectOne(getStatement("getByWxUserId"), wxUserId);
    }

    @Override
    public SelfRobotBookGroupDTO getSelfRobotBookGroupInfoByUser(String wxUserId, Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        map.put("wxUserId", wxUserId);
        return getSessionTemplate().selectOne(getStatement("getSelfRobotBookGroupInfoByUser"), map);
    }

    @Override
    public List<UserBookInfoVO> listUser4ReadingActivity(Map<String, Object> map) {
        return getSessionTemplate().selectList(getStatement("listUser4ReadingActivity"), map);
    }

    @Override
    public List<Long> listId4ReadingActivity(Map<String, Object> map){
        return getSessionTemplate().selectList(getStatement("listId4ReadingActivity"), map);
    }

    @Override
    public List<UserBookInfoVO> listUserByIds(List<Long> idList){
        Map<String,Object> map = new HashMap<>();
        map.put("idList", idList);
        return getSessionTemplate().selectList(getStatement("listUserByIds"), map);
    }

    @Override
    public List<UserBookInfoItemVO> getScanBookInfoByUserNew(String wxUserId, String altId) {
        Map<String, Object> map = new HashMap<>();
        map.put("wxUserId", wxUserId);
        map.put("altId", altId);
        return getSessionTemplate().selectList(getStatement("getScanBookInfoByUserNew"), map);
    }

    @Override
    public List<String> getAltIdListByUserId(String wxUserId) {
        return getSessionTemplate().selectList(getStatement("getAltIdListByUserId"), wxUserId);
    }

    @Override
    public Integer getAddFriendCount4Times(List<Long> agentIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("agentIds", agentIds);
        return getSessionTemplate().selectOne(getStatement("getAddFriendCount4Times"), map);
    }
}
