package com.pcloud.book.rightsSetting.dao.impl;

import com.pcloud.book.rightsSetting.dao.RightsNowPopupDao;
import com.pcloud.book.rightsSetting.entity.RightsNowPopup;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.rightsSetting.dao.impl.RightsNowPopupDaoImpl
 * @Author zhuyajie
 * @Description 弹窗
 * @Date 2020/9/16 10:32
 * @Version 1.0
 **/
@Component
public class RightsNowPopupDaoImpl extends BaseDaoImpl<RightsNowPopup> implements RightsNowPopupDao {

    @Override
    public Integer getUserPopupClickCount(Long wechatUserId, Long bookId, Long channelId, Long adviserId, Integer popupType) {
        Map<String, Object> map = new HashMap<>();
        map.put("wechatUserId", wechatUserId);
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        map.put("popupType", popupType);
        return getSessionTemplate().selectOne(getStatement("getUserPopupClickCount"), map);
    }

    @Override
    public Integer getUserPopupClickCountByServe(RightsNowPopup rightsNowPopup) {
        return getSessionTemplate().selectOne(getStatement("getUserPopupClickCountByServe"), rightsNowPopup);
    }

    @Override
    public Integer getPopupCount(Long wechatUserId, Long bookId, Integer popupType) {
        Map<String, Object> map = new HashMap<>();
        map.put("wechatUserId", wechatUserId);
        map.put("bookId", bookId);
        map.put("popupType", popupType);
        return getSessionTemplate().selectOne(getStatement("getPopupCount"), map);
    }
}
