package com.pcloud.book.group.dto;

import com.pcloud.common.dto.BaseDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @Description
 * @Author pansy
 * @Date 2020/7/21 15:35
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class BookGroupServeDTO extends BaseDto {

    @ApiModelProperty("作品或应用id")
    private Long serveId;

    @ApiModelProperty("类型；APP应用，PRODUCT作品")
    private String serveType;

    @ApiModelProperty("链接")
    private String serveUrl;

    @ApiModelProperty("短链")
    private String shortUrl;

    @ApiModelProperty("社群书id")
    private Long bookGroupId;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("应用或作品名称")
    private String serveName;

    @ApiModelProperty("类型")
    private String fromType;

    @ApiModelProperty("是否超级作者")
    private Boolean isSuper;

    @ApiModelProperty("销售价")
    private Double retailPrice;

    @ApiModelProperty("协议价")
    private Double dealPrice;

    @ApiModelProperty("浏览量")
    private Integer browseCount;

    @ApiModelProperty("浏览人数")
    private Integer browserCount;

    @ApiModelProperty("平均浏览时长")
    private Long avgbrowseTimes;

    @ApiModelProperty("购买次数")
    private Integer saleCount;

    @ApiModelProperty("图片地址")
    private String picUrl;

    @ApiModelProperty("描述信息")
    private String description;

    @ApiModelProperty("类型")
    private String typeCode;
}
