package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("小程序banner")
public class AppletBanner extends BaseEntity {

    @ApiModelProperty("banner图")
    private String bannerPic;

    @ApiModelProperty("跳转类型 1指定页面, 2web页面, 3资讯, 4应用|作品")
    private Integer jumpType;

    @ApiModelProperty("跳转地址")
    private String jumpUrl;

    @ApiModelProperty("排序值")
    private Integer seq;

    @ApiModelProperty("是否展示")
    private Boolean showState;

    @ApiModelProperty("出版社id")
    private Long agentId;

    /**
     * 选择自动获取，将依据当前用户正在读的书，所属分类获取最新上架的资讯，
     * 同时，如果不传banner将会自动获取咨询对应的大图
     */
    @ApiModelProperty("咨询的选择方式 1自定义， 2自动获取")
    private Integer fillType;

    @ApiModelProperty("作品/应用/咨询的ID")
    private Long serveId;

    @ApiModelProperty("作品/应用/咨询的类型")
    private Integer serveType;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("上架时间")
    private Date startTime;

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @ApiModelProperty("下架时间")
    private Date endTime;


    @ApiModelProperty("更新banner是否涉及定时任务")
    private Integer isTime;

}
