package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletBookScoreBiz;
import com.pcloud.book.applet.dto.AppletBookUserScoreDTO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "小程序本服务用户评价相关接口")
@RestController
@RequestMapping("/appletBookScore")
public class AppletBookScoreFacade {
    @Autowired
    private AppletBookScoreBiz appletBookScoreBiz;


    @ApiOperation("新增小程序本服务评价")
    @GetMapping("/add")
    ResponseDto<Long> add(@CookieValue("userInfo") String userInfo,
                          @RequestParam("bookId") Long bookId,
                          @RequestParam("channelId") Long channelId,
                          @RequestParam("adviserId") Long adviserId,
                          @RequestParam("score") Long score) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletBookScoreBiz.score(wechatUserId, bookId, channelId, adviserId, score));
    }


    @GetMapping("/get")
    ResponseDto<List<AppletBookUserScoreDTO>> get(@CookieValue("userInfo") String userInfo,
                                                  @RequestParam("bookId") Long bookId,
                                                  @RequestParam("channelId") Long channelId,
                                                  @RequestParam("adviserId") Long adviserId) {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletBookScoreBiz.get(wechatUserId, bookId, channelId, adviserId));
    }

}
