package com.pcloud.book.book.dao.impl;

import cn.hutool.core.map.MapUtil;
import com.pcloud.book.book.dao.BookCoverDao;
import com.pcloud.book.book.dto.BookCoverDTO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component("bookCoverDao")
public class BookCoverDaoImpl extends BaseDaoImpl<BookCoverDTO> implements BookCoverDao {

    @Override
    public List<BookCoverDTO> selectAllCover() {
        return super.getSessionTemplate().selectList("selectAllCover");
    }

    @Override
    public List<BookCoverDTO> selectByTempletId(Long TempletId) {
        return super.getSessionTemplate().selectList("selectByTempletId", MapUtil.of("TempletId", TempletId));
    }

    @Override
    public BookCoverDTO selectById(String coverId) {
        return super.sqlSessionTemplate.selectOne(getStatement("selectById"), coverId);
    }

    @Override
    public BookCoverDTO selectByTempletIdAndCoverImg(Long templetId, String coverId) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("templetId",templetId);
        paramMap.put("coverId",coverId);
        return super.getSqlSession().selectOne(getStatement("selectByTempletIdAndCoverImg"), paramMap);
    }

    @Override
    public void deleteById(String coverId) {
        getSqlSession().delete(getStatement("deleteById"), coverId);
    }

    @Override
    public void updateCover(BookCoverDTO bookCoverDTO) {
        super.getSqlSession().update(this.getStatement("updateCover"),bookCoverDTO);
    }
}
