package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.push.entity.PushItem;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/6/6 17:47
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PushPlanItemDTO implements Serializable {
    private static final long serialVersionUID = -3956311764049212139L;

    @ApiModelProperty("群发id")
    private Long pushId;

    @ApiModelProperty("发送类型（1:立即发送 2:单次发送 3:每天发送 4:每周发送）")
    private Integer pushType;

    @ApiModelProperty("发送时间")
    private String pushTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("开始时间")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("结束时间")
    private Date endTime;

    @ApiModelProperty("周几")
    private Integer weekDay;

    @ApiModelProperty("消息推送项模型集合")
    private List<PushItem> pushItems;

    public Long getPushId() {
        return pushId;
    }

    public void setPushId(Long pushId) {
        this.pushId = pushId;
    }

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public String getPushTime() {
        return pushTime;
    }

    public void setPushTime(String pushTime) {
        this.pushTime = pushTime;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Integer getWeekDay() {
        return weekDay;
    }

    public void setWeekDay(Integer weekDay) {
        this.weekDay = weekDay;
    }

    public List<PushItem> getPushItems() {
        return pushItems;
    }

    public void setPushItems(List<PushItem> pushItems) {
        this.pushItems = pushItems;
    }

    @Override
    public String toString() {
        return "PushPlanItemDTO{" +
                "pushId=" + pushId +
                ", pushType=" + pushType +
                ", pushTime='" + pushTime + '\'' +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", weekDay=" + weekDay +
                ", pushItems=" + pushItems +
                '}';
    }
}
