package com.pcloud.book.reading.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.pcloud.book.reading.biz.ReadingActivityBiz;
import com.pcloud.book.reading.service.ReadingActivityService;
import com.pcloud.common.core.aspect.ParamLog;

import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * @描述：共读活动
 * @作者：zhuyajie
 * @创建时间：16:00 2020/1/15
 * @版本：1.0
 */
@RestController("readingActivityService")
@RequestMapping("readingActivityService")
public class ReadingActivityServiceImpl implements ReadingActivityService {

    @Autowired
    private ReadingActivityBiz readingActivityBiz;

    @Override
    @PostMapping("sendInviteMsg")
    @ParamLog("定时任务发邀请语")
    public void sendInviteMsg(@RequestBody @ApiParam Map<String, Object> map) {
        Long activityId = JSON.parseObject(JSON.toJSONString(map.get("activityId")), new TypeReference<Long>() {
        });
        if (null == activityId) {
            return;
        }
        readingActivityBiz.sendQuartzMsg("invite", activityId);
    }

    @Override
    @PostMapping("sendStartMsg")
    @ParamLog("定时任务发开场语")
    public void sendStartMsg(@RequestBody @ApiParam Map<String, Object> map) {
        Long activityId = JSON.parseObject(JSON.toJSONString(map.get("activityId")), new TypeReference<Long>() {
        });
        if (null == activityId) {
            return;
        }
        readingActivityBiz.sendQuartzMsg("start", activityId);
    }

    @Override
    @PostMapping("sendEndMsg")
    @ParamLog("定时任务发结束语")
    public void sendEndMsg(@RequestBody @ApiParam Map<String, Object> map) {
        Long activityId = JSON.parseObject(JSON.toJSONString(map.get("activityId")), new TypeReference<Long>() {
        });
        if (null == activityId) {
            return;
        }
        readingActivityBiz.sendQuartzMsg("end", activityId);
    }

    @Override
    @ParamLog("定时任务发打卡每日提醒")
    @PostMapping("/sendClockRemind")
    public void sendClockRemind(@RequestBody @ApiParam Map<String, Object> map) {
        Long activityId = JSON.parseObject(JSON.toJSONString(map.get("activityId")), new TypeReference<Long>() {
        });
        if (null == activityId) {
            return;
        }
        readingActivityBiz.sendClockRemind(activityId);
    }
}
