package com.pcloud.book.weixinclock.dao;

import com.pcloud.book.weixinclock.entity.WeixinClockCoupon;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @Describe: 微信群打卡优惠券dao
 * @Author: zhangdongwei
 * @Date: Create on 11:18 2019/11/12 0012
 */
public interface WeixinClockCouponDao extends BaseDao<WeixinClockCoupon> {
    /**
     * 获取微信群打卡基本信息
     * @param id
     * @return
     */
    WeixinClockCoupon getBaseById(Long id);

    /**
     * 根据打卡id获取打卡奖励优惠券信息
     * @param weixinClockId
     * @return
     */
    WeixinClockCoupon getBaseByClockId(Long weixinClockId);

    /**
     * 根据打卡id列表获取打卡优惠券列表
     * @param clockIds
     * @return
     */
    Map<Long, WeixinClockCoupon> getByClockIds(List<Long> clockIds);
}
