package com.pcloud.book.adnews.facade;

import com.pcloud.book.adnews.entity.AdNewsClickRecord;
import com.pcloud.book.adnews.entity.AdNewsSet;
import com.pcloud.book.adnews.dto.AdNewsListParam;
import com.pcloud.book.adnews.entity.AdNewsWechat;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.*;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(value = "pcloud-service-book", qualifier = "adNewsFacadeCloud", path = "adNews")
@Api(description = "推送群消息外部接口")
public interface AdNewsFacade {

    @ApiOperation("新增编辑端早晚报设置")
    @PostMapping("/createAdNewsSet")
    ResponseDto<?> createAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("编辑端早晚报设置") AdNewsSet adNewsSet
    ) throws BizException, PermissionException;

    @ApiOperation("修改编辑端早晚报设置")
    @PostMapping("/updateAdNewsSet")
    ResponseDto<?> updateAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("编辑端早晚报设置") AdNewsSet adNewsSet
    ) throws BizException, PermissionException;

    @ApiOperation("获取编辑早晚报设置")
    @GetMapping("/getAdNewsSet")
    ResponseDto<?> getAdNewsSet(
            @RequestHeader("token") @ApiParam("token信息") String token
    ) throws BizException, PermissionException;

    @Deprecated
    @ApiOperation("编辑添加选择的早晚报素材")
    @PostMapping("/createAdNewsChooseBatch")
    ResponseDto<?> createAdNewsChooseBatch(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("新闻id集合") List<Long> adNewsIds
    ) throws BizException, PermissionException;

    @Deprecated
    @ApiOperation("编辑移除选择的早晚报素材")
    @GetMapping("/deleteAdNewsChoose")
    ResponseDto<?> deleteAdNewsChoose(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam @ApiParam("adNewsChooseId") Long adNewsChooseId
    ) throws BizException, PermissionException;

    @Deprecated
    @ApiOperation("获取编辑选择的早晚报素材库")
    @GetMapping("/getAdNewsChooseList")
    ResponseDto<?> getAdNewsChooseList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "title", required = false) @ApiParam("标题") String title,
            @RequestParam(value = "hasUsed", required = false) @ApiParam("是否已使用") Boolean hasUsed,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("早晚报素材库管理（只获取编辑已选公众号的素材）")
    @PostMapping("/getAdNewsList")
    ResponseDto<?> getAdNewsList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("查询参数") AdNewsListParam adNewsListParam
    ) throws BizException, PermissionException;

    @ApiOperation("禁用/解除禁用")
    @GetMapping("/saveAdNewsBan")
    ResponseDto<?> saveAdNewsBan(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("adNewsId") @ApiParam("新闻id") Long adNewsId,
            @RequestParam("hasBan") @ApiParam("禁止推送") Integer hasBan
    ) throws BizException, PermissionException;

    @ApiOperation("编辑反馈公众号")
    @PostMapping("/addAdNewsWechat")
    ResponseDto<?> addAdNewsWechat(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("AdNewsWechat") AdNewsWechat adNewsWechat
    ) throws BizException, PermissionException;

    @ApiOperation("获取编辑自有公众号")
    @GetMapping("/getAdNewsWechatList")
    ResponseDto<?> getAdNewsWechatListForAdviser(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("添加编辑选择的公众号")
    @PostMapping("/createAdNewsWechatChooseBatch")
    ResponseDto<?> createAdNewsWechatChooseBatch(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestBody @ApiParam("选择的公众号主键") List<Long> adNewsWechatIds
    ) throws BizException, PermissionException;

    @ApiOperation("移除编辑已选择的公众号")
    @GetMapping("/deleteAdNewsWechatChoose")
    ResponseDto<?> deleteAdNewsWechatChoose(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "adNewsWechatId") @ApiParam("公众号主键") Long adNewsWechatId
    ) throws BizException, PermissionException;

    @ApiOperation("获取编辑已选择的公众号")
    @GetMapping("/getAdNewsWechatChooseList")
    ResponseDto<?> getAdNewsWechatChooseList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("获取所有的公众号列表")
    @GetMapping("/getAdNewsWechatList")
    ResponseDto<?> getAdNewsWechatList(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;

    @ApiOperation("获取早晚报发送记录")
    @GetMapping("/getAdNewsMessageStatistic")
    ResponseDto<?> getAdNewsMessageStatistic(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam(value = "title", required = false) @ApiParam("群名称、群分类、社群码、社群书") String title,
            @RequestParam(value = "beginTime", required = false) @ApiParam("开始日期") String beginTime,
            @RequestParam(value = "endTime", required = false) @ApiParam("结束日期") String endTime,
            @RequestParam(value = "proLabelId", required = false) @ApiParam("专业") Long proLabelId,
            @RequestParam(value = "depLabelId", required = false) @ApiParam("深度") Long depLabelId,
            @RequestParam(value = "purLabelId", required = false) @ApiParam("目的") Long purLabelId,
            @RequestParam(value = "currentPage", required = false, defaultValue = "0") @ApiParam("当前页") Integer currentPage,
            @RequestParam(value = "numPerPage", required = false, defaultValue = "10") @ApiParam("每页条数") Integer numPerPage
    ) throws BizException, PermissionException;


    @ApiOperation("查询早晚报发送详情")
    @GetMapping("/getAdNewsGroupRecord")
    ResponseDto<?> getAdNewsGroupRecord(
            @RequestHeader("token") @ApiParam("token信息") String token,
            @RequestParam("messageStatisticId") @ApiParam("统计表id") Long messageStatisticId
    ) throws BizException, PermissionException;

    @ApiOperation("记录用户点击量")
    @PostMapping("/addAdNewsClickRecord")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userInfo", value = "Cookie", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "adNewsClickRecord", value = "用户点击量对象", dataType = "AdNewsClickRecord", paramType = "body")})
    ResponseDto<?> addAdNewsClickRecord(
        @CookieValue("userInfo") @ApiParam("用户信息") String userInfo,
        @RequestBody @ApiParam("用户点击量对象") AdNewsClickRecord adNewsClickRecord
    ) throws BizException, PermissionException;
}
