package com.pcloud.book.advertising.dao;

import java.util.List;
import com.pcloud.book.advertising.entity.AdvertisingAdviserPermission;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 广告位编辑书刊权限数据访问层接口
 * @author PENG
 * @date 2019/2/28
 */
public interface AdvertisingAdviserPermissionDao extends BaseDao<AdvertisingAdviserPermission> {

    /**
     * 批量插入
     * @param list 列表
     * @return
     */
    long batchInsert(List<AdvertisingAdviserPermission> list);

    /**
     * 根据编辑ID删除
     * @param adviserId 编辑ID
     * @return
     */
    long deleteByAdviserId(Long adviserId);
}
