package com.pcloud.book.book.dao.impl;

import com.pcloud.book.book.dao.BookLabelDao;
import com.pcloud.book.book.entity.BookLabel;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/12/27 17:23
 **/
@Repository("bookLabelDao")
public class BookLabelDaoImpl extends BaseDaoImpl<BookLabel> implements BookLabelDao {


    @Override
    public List<BookLabel> getListByType(Integer type) {
        return super.getSqlSession().selectList(super.getStatement("getListByType"), type);
    }

    @Override
    public List<BookLabel> getAll() {
        return super.getSqlSession().selectList(super.getStatement("getAll"));
    }

    @Override
    public Map<Long, BookLabel> getMapByIds(List<Long> list) {
        return super.getSqlSession().selectMap(super.getStatement("getMapByIds"), list,"id");
    }
}
